/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.identifiable.alias;

import de.digitalcollections.model.identifiable.IdentifiableType;
import de.digitalcollections.model.identifiable.alias.UrlAlias;
import de.digitalcollections.model.identifiable.entity.EntityType;
import de.digitalcollections.model.identifiable.entity.Website;
import java.time.LocalDateTime;
import java.util.Locale;
import java.util.UUID;

public class UrlAliasBuilder {
    UrlAlias urlAlias = new UrlAlias();

    public UrlAlias build() {
        return this.urlAlias;
    }

    public UrlAliasBuilder createdAt(String createdAt) {
        this.urlAlias.setCreated(LocalDateTime.parse(createdAt));
        return this;
    }

    public UrlAliasBuilder lastPublishedAt(String lastPublishedAt) {
        this.urlAlias.setLastPublished(LocalDateTime.parse(lastPublishedAt));
        return this;
    }

    public UrlAliasBuilder isPrimary() {
        this.urlAlias.setPrimary(true);
        return this;
    }

    public UrlAliasBuilder withSlug(String slug) {
        this.urlAlias.setSlug(slug);
        return this;
    }

    public UrlAliasBuilder withTargetLanguage(Locale targetLanguage) {
        this.urlAlias.setTargetLanguage(targetLanguage);
        return this;
    }

    public UrlAliasBuilder withTargetLanguage(String targetLanguage) {
        this.urlAlias.setTargetLanguage(Locale.forLanguageTag(targetLanguage));
        return this;
    }

    public UrlAliasBuilder withTargetType(IdentifiableType identifiableType, EntityType entityType) {
        this.urlAlias.setTargetIdentifiableType(identifiableType);
        this.urlAlias.setTargetEntityType(entityType);
        return this;
    }

    public UrlAliasBuilder withTargetUuid(String targetUuid) {
        this.urlAlias.setTargetUuid(UUID.fromString(targetUuid));
        return this;
    }

    public UrlAliasBuilder withUuid(String uuid) {
        this.urlAlias.setUuid(UUID.fromString(uuid));
        return this;
    }

    public UrlAliasBuilder withWebsite(Website website) {
        this.urlAlias.setWebsite(website);
        return this;
    }
}

