/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.identifiable;

import de.digitalcollections.model.UniqueObject;
import de.digitalcollections.model.identifiable.IdentifiableType;
import de.digitalcollections.model.identifiable.Identifier;
import de.digitalcollections.model.identifiable.alias.LocalizedUrlAliases;
import de.digitalcollections.model.identifiable.alias.UrlAlias;
import de.digitalcollections.model.identifiable.entity.Website;
import de.digitalcollections.model.identifiable.resource.ImageFileResource;
import de.digitalcollections.model.text.LocalizedStructuredContent;
import de.digitalcollections.model.text.LocalizedText;
import de.digitalcollections.model.view.RenderingHintsPreviewImage;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class Identifiable
extends UniqueObject {
    protected LocalizedStructuredContent description;
    protected Set<Identifier> identifiers = new HashSet<Identifier>();
    protected LocalizedText label;
    protected LocalizedUrlAliases localizedUrlAliases;
    protected ImageFileResource previewImage;
    protected RenderingHintsPreviewImage previewImageRenderingHints;
    protected IdentifiableType type;

    public void addIdentifier(Identifier identifier) {
        this.identifiers.add(Objects.requireNonNull(identifier));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Identifiable)) {
            return false;
        }
        Identifiable that = (Identifiable)o;
        return Objects.equals(this.created, that.created) && Objects.equals(this.description, that.description) && Objects.equals(this.identifiers, that.identifiers) && Objects.equals(this.label, that.label) && Objects.equals(this.lastModified, that.lastModified) && Objects.equals(this.localizedUrlAliases, that.localizedUrlAliases) && Objects.equals(this.previewImage, that.previewImage) && Objects.equals(this.previewImageRenderingHints, that.previewImageRenderingHints) && this.type == that.type && Objects.equals(this.uuid, that.uuid);
    }

    public LocalizedStructuredContent getDescription() {
        return this.description;
    }

    public Identifier getIdentifierByNamespace(String namespace) {
        if (namespace == null || this.identifiers == null || this.identifiers.isEmpty()) {
            return null;
        }
        for (Identifier identifier : this.identifiers) {
            if (!namespace.equals(identifier.getNamespace())) continue;
            return identifier;
        }
        return null;
    }

    public Set<Identifier> getIdentifiers() {
        return this.identifiers;
    }

    public LocalizedText getLabel() {
        return this.label;
    }

    public LocalizedUrlAliases getLocalizedUrlAliases() {
        return this.localizedUrlAliases;
    }

    public ImageFileResource getPreviewImage() {
        return this.previewImage;
    }

    public RenderingHintsPreviewImage getPreviewImageRenderingHints() {
        return this.previewImageRenderingHints;
    }

    public UrlAlias getPrimaryUrlAlias(Locale locale, Website website) {
        UrlAlias urlAlias;
        if (this.localizedUrlAliases == null || this.localizedUrlAliases.isEmpty()) {
            return null;
        }
        List urlAliases = (List)this.localizedUrlAliases.get(Locale.forLanguageTag(locale.getLanguage()));
        if (urlAliases == null || urlAliases.isEmpty()) {
            return null;
        }
        Supplier<Stream> primaries = () -> urlAliases.stream().filter(u -> u.isPrimary());
        if (website != null && (urlAlias = (UrlAlias)primaries.get().filter(u -> u.getWebsite() != null && u.getWebsite().getUuid().equals(website.getUuid())).findFirst().orElse(null)) != null) {
            return urlAlias;
        }
        return primaries.get().filter(u -> u.getWebsite() == null).findFirst().orElse(null);
    }

    public IdentifiableType getType() {
        return this.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.created, this.description, this.identifiers, this.label, this.lastModified, this.localizedUrlAliases, this.previewImage, this.previewImageRenderingHints, this.type, this.uuid});
    }

    public void setDescription(LocalizedStructuredContent description) {
        this.description = description;
    }

    public void setIdentifiers(Set<Identifier> identifiers) {
        this.identifiers = identifiers;
    }

    public void setLabel(String label) {
        this.label = new LocalizedText(Locale.ROOT, label);
    }

    public void setLabel(LocalizedText label) {
        this.label = label;
    }

    public void setLocalizedUrlAliases(LocalizedUrlAliases localizedUrlAliases) {
        this.localizedUrlAliases = localizedUrlAliases;
    }

    public void setPreviewImage(ImageFileResource previewImage) {
        this.previewImage = previewImage;
    }

    public void setPreviewImageRenderingHints(RenderingHintsPreviewImage previewImageRenderingHints) {
        this.previewImageRenderingHints = previewImageRenderingHints;
    }

    public void setType(IdentifiableType identifiableType) {
        this.type = identifiableType;
    }
}

