/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.identifiable;

import de.digitalcollections.model.UniqueObject;
import de.digitalcollections.model.file.MimeType;
import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.identifiable.IdentifiableType;
import de.digitalcollections.model.identifiable.Identifier;
import de.digitalcollections.model.identifiable.alias.LocalizedUrlAliases;
import de.digitalcollections.model.identifiable.alias.UrlAliasBuilder;
import de.digitalcollections.model.identifiable.resource.ImageFileResource;
import de.digitalcollections.model.identifiable.resource.PreviewImageBuilder;
import de.digitalcollections.model.text.LocalizedStructuredContent;
import de.digitalcollections.model.text.LocalizedText;
import de.digitalcollections.model.text.StructuredContent;
import de.digitalcollections.model.text.contentblock.Paragraph;
import de.digitalcollections.model.view.RenderingHintsPreviewImage;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.util.StringUtils;

public abstract class AbstractIdentifiableBuilder<I extends Identifiable, B extends AbstractIdentifiableBuilder> {
    protected I identifiable;
    Set<Identifier> identifiers;
    private final Class<I> identifiableType = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];

    public AbstractIdentifiableBuilder() {
        try {
            this.identifiable = (Identifiable)this.identifiableType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Cannot create new instance of " + this.identifiableType.getName() + ": " + e, e);
        }
        ((Identifiable)this.identifiable).setType(this.getIdentifiableType());
    }

    protected abstract IdentifiableType getIdentifiableType();

    public B withUuid(String uuid) {
        ((UniqueObject)this.identifiable).setUuid(UUID.fromString(uuid));
        return (B)this;
    }

    public B withUuid(UUID uuid) {
        ((UniqueObject)this.identifiable).setUuid(uuid);
        return (B)this;
    }

    public B withRandomUuid() {
        ((UniqueObject)this.identifiable).setUuid(UUID.randomUUID());
        return (B)this;
    }

    public B createdAt(String createdAt) {
        ((UniqueObject)this.identifiable).setCreated(LocalDateTime.parse(createdAt));
        return (B)this;
    }

    public B createdAt(LocalDateTime createdAt) {
        ((UniqueObject)this.identifiable).setCreated(createdAt);
        return (B)this;
    }

    public B lastModifiedAt(String lastModifiedAt) {
        ((UniqueObject)this.identifiable).setLastModified(LocalDateTime.parse(lastModifiedAt));
        return (B)this;
    }

    public B lastModifiedAt(LocalDateTime lastModifiedAt) {
        ((UniqueObject)this.identifiable).setLastModified(lastModifiedAt);
        return (B)this;
    }

    public B withIdentifier(String namespace, String id, String uuid) {
        if (this.identifiers == null) {
            this.identifiers = new HashSet<Identifier>();
        }
        Identifier identifier = new Identifier();
        identifier.setNamespace(namespace);
        identifier.setId(id);
        if (uuid != null) {
            identifier.setUuid(UUID.fromString(uuid));
        }
        this.identifiers.add(identifier);
        return (B)this;
    }

    public B withIdentifier(String namespace, String id) {
        return this.withIdentifier(namespace, id, null);
    }

    public B withLabel(Locale locale, String localizedLabel) {
        LocalizedText label = ((Identifiable)this.identifiable).getLabel();
        if (label == null) {
            label = new LocalizedText();
        }
        label.setText(locale, localizedLabel);
        ((Identifiable)this.identifiable).setLabel(label);
        return (B)this;
    }

    public B withLabel(String nonlocalizedLabel) {
        ((Identifiable)this.identifiable).setLabel(nonlocalizedLabel);
        return (B)this;
    }

    public B withPreviewImage(ImageFileResource previewImage) {
        ((Identifiable)this.identifiable).setPreviewImage(previewImage);
        return (B)this;
    }

    public B withPreviewImage(String url, int width, int height) {
        String[] fileNameParts = url.split("/\\//");
        ImageFileResource previewImage = new PreviewImageBuilder().withFileName(fileNameParts[fileNameParts.length - 1]).withUri(url).withSize(width, height).build();
        ((Identifiable)this.identifiable).setPreviewImage(previewImage);
        return (B)this;
    }

    public B withPreviewImage(String fileName, String uuid, String uri) {
        ImageFileResource previewImage = new PreviewImageBuilder(uuid).withFileName(fileName).withUri(uri).build();
        ((Identifiable)this.identifiable).setPreviewImage(previewImage);
        return (B)this;
    }

    public B withPreviewImage(String fileName, String uuid, String uri, MimeType mimeType) {
        ImageFileResource previewImage = new PreviewImageBuilder(uuid).withFileName(fileName).withUri(uri).withMimeType(mimeType).build();
        ((Identifiable)this.identifiable).setPreviewImage(previewImage);
        return (B)this;
    }

    public B withPreviewImage(String fileName, String uuid, String uri, MimeType mimeType, String httpBaseUrl) {
        ImageFileResource previewImage = new PreviewImageBuilder(uuid).withFileName(fileName).withUri(uri).withMimeType(mimeType).withHttpBaseUrl(httpBaseUrl).build();
        ((Identifiable)this.identifiable).setPreviewImage(previewImage);
        return (B)this;
    }

    public B withOpenPreviewImageInNewWindow() {
        RenderingHintsPreviewImage previewImageRenderingHints = ((Identifiable)this.identifiable).getPreviewImageRenderingHints();
        if (previewImageRenderingHints == null) {
            previewImageRenderingHints = new RenderingHintsPreviewImage();
        }
        previewImageRenderingHints.setOpenLinkInNewWindow(true);
        ((Identifiable)this.identifiable).setPreviewImageRenderingHints(previewImageRenderingHints);
        return (B)this;
    }

    public B withoutOpenPreviewInNewWindow() {
        RenderingHintsPreviewImage previewImageRenderingHints = ((Identifiable)this.identifiable).getPreviewImageRenderingHints();
        if (previewImageRenderingHints == null) {
            previewImageRenderingHints = new RenderingHintsPreviewImage();
        }
        previewImageRenderingHints.setOpenLinkInNewWindow(false);
        ((Identifiable)this.identifiable).setPreviewImageRenderingHints(previewImageRenderingHints);
        return (B)this;
    }

    public B withAltTextFromLabel() {
        RenderingHintsPreviewImage previewImageRenderingHints = ((Identifiable)this.identifiable).getPreviewImageRenderingHints();
        if (previewImageRenderingHints == null) {
            previewImageRenderingHints = new RenderingHintsPreviewImage();
        }
        previewImageRenderingHints.setAltText(((Identifiable)this.identifiable).getLabel());
        ((Identifiable)this.identifiable).setPreviewImageRenderingHints(previewImageRenderingHints);
        return (B)this;
    }

    public B withAltText(Locale locale, String text) {
        LocalizedText altText;
        RenderingHintsPreviewImage previewImageRenderingHints = ((Identifiable)this.identifiable).getPreviewImageRenderingHints();
        if (previewImageRenderingHints == null) {
            previewImageRenderingHints = new RenderingHintsPreviewImage();
        }
        if ((altText = previewImageRenderingHints.getAltText()) == null) {
            altText = new LocalizedText();
        }
        altText.setText(locale, text);
        previewImageRenderingHints.setAltText(altText);
        ((Identifiable)this.identifiable).setPreviewImageRenderingHints(previewImageRenderingHints);
        return (B)this;
    }

    public B withTitleFromLabel() {
        RenderingHintsPreviewImage previewImageRenderingHints = ((Identifiable)this.identifiable).getPreviewImageRenderingHints();
        if (previewImageRenderingHints == null) {
            previewImageRenderingHints = new RenderingHintsPreviewImage();
        }
        previewImageRenderingHints.setTitle(((Identifiable)this.identifiable).getLabel());
        ((Identifiable)this.identifiable).setPreviewImageRenderingHints(previewImageRenderingHints);
        return (B)this;
    }

    public B withTitle(Locale locale, String text) {
        LocalizedText title;
        RenderingHintsPreviewImage previewImageRenderingHints = ((Identifiable)this.identifiable).getPreviewImageRenderingHints();
        if (previewImageRenderingHints == null) {
            previewImageRenderingHints = new RenderingHintsPreviewImage();
        }
        if ((title = previewImageRenderingHints.getTitle()) == null) {
            title = new LocalizedText();
        }
        title.setText(locale, text);
        previewImageRenderingHints.setTitle(title);
        ((Identifiable)this.identifiable).setPreviewImageRenderingHints(previewImageRenderingHints);
        return (B)this;
    }

    public B withDescription(Locale locale, String text) {
        StructuredContent localizedDescription;
        LocalizedStructuredContent description = ((Identifiable)this.identifiable).getDescription();
        if (description == null) {
            description = new LocalizedStructuredContent();
        }
        if ((localizedDescription = (StructuredContent)description.get(locale)) == null) {
            localizedDescription = new StructuredContent();
        }
        Paragraph paragraph = StringUtils.hasText((String)text) ? new Paragraph(text) : new Paragraph();
        localizedDescription.addContentBlock(paragraph);
        description.put(locale, localizedDescription);
        ((Identifiable)this.identifiable).setDescription(description);
        return (B)this;
    }

    public B withPrimaryLocalizedUrlAlias(String slug) {
        LocalizedUrlAliases localizedUrlAliases = new LocalizedUrlAliases(new UrlAliasBuilder().withSlug(slug).isPrimary().build());
        ((Identifiable)this.identifiable).setLocalizedUrlAliases(localizedUrlAliases);
        return (B)this;
    }

    public I build() {
        if (this.identifiers != null && !this.identifiers.isEmpty()) {
            ((Identifiable)this.identifiable).setIdentifiers(this.identifiers.stream().peek(i -> i.setIdentifiable(((UniqueObject)this.identifiable).getUuid())).collect(Collectors.toSet()));
        }
        if (((Identifiable)this.identifiable).getLocalizedUrlAliases() != null && !((Identifiable)this.identifiable).getLocalizedUrlAliases().isEmpty()) {
            ((Identifiable)this.identifiable).getLocalizedUrlAliases().forEach((locale, urlAliasList) -> urlAliasList.forEach(u -> u.setTargetUuid(((UniqueObject)this.identifiable).getUuid())));
        }
        return this.identifiable;
    }
}

