/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.filter;

import de.digitalcollections.model.filter.FilterCriterion;
import de.digitalcollections.model.filter.FilterCriterionBuilder;
import de.digitalcollections.model.filter.Filtering;
import java.util.ArrayList;
import java.util.List;

public class FilteringBuilder {
    private final List<FilterCriterion> filterCriterias = new ArrayList<FilterCriterion>();

    public FilteringBuilder add(String expression, FilterCriterion filterCriterion) {
        if (filterCriterion != null) {
            filterCriterion.setExpression(expression);
        }
        return this.add(filterCriterion);
    }

    public FilteringBuilder add(FilterCriterion filterCriterion) {
        if (filterCriterion != null) {
            if (filterCriterion.getExpression() == null) {
                throw new IllegalArgumentException("expression of a filter criterion must not be null!");
            }
            this.filterCriterias.add(filterCriterion);
        }
        return this;
    }

    public Filtering build() {
        return new Filtering(this.filterCriterias);
    }

    public FilterCriterionBuilder filter(String expression) {
        return new FilterCriterionBuilder(expression, false, this);
    }

    public FilterCriterionBuilder filterNative(String expression) {
        return new FilterCriterionBuilder(expression, true, this);
    }
}

