/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.filter;

import de.digitalcollections.model.filter.FilterCriterion;
import de.digitalcollections.model.filter.FilteringBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class Filtering {
    private List<FilterCriterion> filterCriteria = new ArrayList<FilterCriterion>();

    public static FilteringBuilder defaultBuilder() {
        return new FilteringBuilder();
    }

    public Filtering() {
    }

    public Filtering(List<FilterCriterion> filterCriteria) {
        this.filterCriteria = filterCriteria;
    }

    public List<FilterCriterion> add(Filtering filtering) {
        if (filtering == null || filtering.getFilterCriteria() == null) {
            return this.getFilterCriteria();
        }
        if (this.getFilterCriteria() == null) {
            this.setFilterCriteria(filtering.getFilterCriteria());
            return this.getFilterCriteria();
        }
        ArrayList<FilterCriterion> mergedList = new ArrayList<FilterCriterion>(this.getFilterCriteria());
        mergedList.addAll(filtering.getFilterCriteria());
        this.setFilterCriteria(mergedList);
        return this.getFilterCriteria();
    }

    public List<FilterCriterion> getFilterCriteria() {
        return this.filterCriteria;
    }

    public FilterCriterion getFilterCriterionFor(String property) {
        return this.filterCriteria.stream().filter(f -> f.getExpression().equals(property)).findFirst().orElse(null);
    }

    public Iterator<FilterCriterion> iterator() {
        return this.filterCriteria.iterator();
    }

    public void setFilterCriteria(List<FilterCriterion> filterCriteria) {
        this.filterCriteria = filterCriteria;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Filtering)) {
            return false;
        }
        Filtering filtering = (Filtering)o;
        return Objects.equals(this.filterCriteria, filtering.filterCriteria);
    }

    public int hashCode() {
        return Objects.hash(this.filterCriteria) + Objects.hash("Filtering");
    }

    public String toString() {
        return "Filtering{filterCriteria=" + this.filterCriteria + "}";
    }
}

