/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.filter;

import de.digitalcollections.model.filter.FilterOperation;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;

public class FilterCriterion<T> {
    private String expression;
    private Comparable<?> maxValue;
    private Comparable<?> minValue;
    private boolean nativeExpression;
    private FilterOperation operation;
    private Object value;
    private Collection<?> values;

    public FilterCriterion() {
    }

    public FilterCriterion(String expression, boolean nativeExpression, FilterOperation operation, Object value, Comparable<?> minValue, Comparable<?> maxValue, Collection<?> values) {
        this.expression = expression;
        this.nativeExpression = nativeExpression;
        this.operation = operation;
        this.value = value;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.values = values;
        this.validate();
        if (minValue != null && maxValue != null && minValue.compareTo(maxValue) > 0) {
            this.minValue = maxValue;
            this.maxValue = minValue;
        }
    }

    public FilterCriterion(String expression, FilterOperation operation, Object value, Comparable<?> minValue, Comparable<?> maxValue, Collection<?> values) {
        this(expression, false, operation, value, minValue, maxValue, values);
    }

    public FilterCriterion(String expression, FilterOperation operation, Object value) {
        this(expression, false, operation, value);
    }

    public FilterCriterion(String expression, boolean nativeExpression, FilterOperation operation, Object value) {
        this(expression, nativeExpression, operation, value, null, null, null);
        if (operation == FilterOperation.BETWEEN || operation == FilterOperation.IN || operation == FilterOperation.NOT_IN) {
            throw new IllegalArgumentException("this constructor only supports single value operations");
        }
    }

    public FilterCriterion(String expression, FilterOperation operation) {
        this(expression, false, operation);
    }

    public FilterCriterion(String expression, boolean nativeExpression, FilterOperation operation) {
        this(expression, nativeExpression, operation, null, null, null, null);
    }

    public String getExpression() {
        return this.expression;
    }

    @Deprecated
    public String getFieldName() {
        return this.expression;
    }

    public Comparable<?> getMaxValue() {
        return this.maxValue;
    }

    public Comparable<?> getMinValue() {
        return this.minValue;
    }

    public FilterOperation getOperation() {
        return this.operation;
    }

    public Object getValue() {
        return this.value;
    }

    public Collection<?> getValues() {
        return this.values;
    }

    public boolean isNativeExpression() {
        return this.nativeExpression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    @Deprecated
    public void setFieldName(String expression) {
        this.setExpression(expression);
    }

    public void setNativeExpression(boolean nativeExpression) {
        this.nativeExpression = nativeExpression;
    }

    public String toString() {
        if (this.operation == null) {
            return "";
        }
        String criterion = this.expression + "=" + this.operation + ":";
        switch (this.operation.getOperandCount()) {
            case SINGLEVALUE: {
                criterion = criterion + this.value;
                break;
            }
            case MIN_MAX_VALUES: {
                criterion = criterion + this.minValue + "," + this.maxValue;
                break;
            }
            case MULTIVALUE: {
                criterion = criterion + this.values.stream().map(Object::toString).collect(Collectors.joining(","));
            }
        }
        if (this.nativeExpression) {
            return "native expression / " + criterion;
        }
        return criterion;
    }

    private void validate() {
        if (this.operation == null) {
            throw new IllegalArgumentException("a filter criterion needs an operation");
        }
        FilterOperation.OperandCount operandCount = this.operation.getOperandCount();
        switch (operandCount) {
            case NO_VALUE: {
                if (this.value == null && this.minValue == null && this.maxValue == null && (this.values == null || this.values.isEmpty())) break;
                throw new IllegalArgumentException("operation does not support operand values!");
            }
            case SINGLEVALUE: {
                if (this.value != null && this.minValue == null && this.maxValue == null && (this.values == null || this.values.isEmpty())) break;
                throw new IllegalArgumentException("operation requires exactly one operand value!");
            }
            case MIN_MAX_VALUES: {
                if (this.value == null && this.minValue != null && this.maxValue != null && (this.values == null || this.values.isEmpty())) break;
                throw new IllegalArgumentException("operation requires exactly one min and one max value!");
            }
            case MULTIVALUE: {
                if (this.value == null && this.minValue == null && this.maxValue == null && this.values != null && !this.values.isEmpty()) break;
                throw new IllegalArgumentException("operation requires a list of values!");
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FilterCriterion)) {
            return false;
        }
        FilterCriterion that = (FilterCriterion)o;
        return this.nativeExpression == that.nativeExpression && Objects.equals(this.expression, that.expression) && Objects.equals(this.maxValue, that.maxValue) && Objects.equals(this.minValue, that.minValue) && this.operation == that.operation && Objects.equals(this.value, that.value) && Objects.equals(this.values, that.values);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.expression, this.maxValue, this.minValue, this.nativeExpression, this.operation, this.value, this.values});
    }
}

