/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.time;

import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.temporal.TemporalAccessor;
import org.threeten.extra.chrono.JulianDate;
import org.wikidata.wdtk.datamodel.interfaces.ItemIdValue;
import org.wikidata.wdtk.datamodel.interfaces.ValueVisitor;

public class TimeValue
implements org.wikidata.wdtk.datamodel.interfaces.TimeValue {
    private int afterTolerance;
    private int beforeTolerance;
    private byte day;
    private byte hour;
    private byte minute;
    private byte month;
    private byte precision;
    private String preferredCalendarModel = "http://www.wikidata.org/entity/Q1985727";
    private byte second;
    private int timezoneOffset;
    private long year;

    public TimeValue() {
        this.afterTolerance = 0;
        this.beforeTolerance = 0;
        this.day = 0;
        this.hour = 0;
        this.minute = 0;
        this.month = 0;
        this.precision = 0;
        this.second = 0;
        this.timezoneOffset = 0;
        this.year = 0L;
    }

    public TimeValue(long year, byte month, byte day, byte hour, byte minute, byte second, byte precision, int beforeTolerance, int afterTolerance, int timezoneOffset, String preferredCalendarModel) {
        this.afterTolerance = afterTolerance;
        this.beforeTolerance = beforeTolerance;
        this.preferredCalendarModel = preferredCalendarModel;
        this.day = day;
        this.hour = hour;
        this.minute = minute;
        this.month = month;
        this.precision = precision;
        this.second = second;
        this.timezoneOffset = timezoneOffset;
        this.year = year;
    }

    public TimeValue(long year) {
        this();
        this.precision = (byte)9;
        this.year = year;
    }

    public TimeValue(long year, byte month, byte day) {
        this();
        this.precision = (byte)11;
        this.day = day;
        this.month = month;
        this.year = year;
    }

    public <T> T accept(ValueVisitor<T> valueVisitor) {
        return null;
    }

    public int getAfterTolerance() {
        return this.afterTolerance;
    }

    public int getBeforeTolerance() {
        return this.beforeTolerance;
    }

    public byte getDay() {
        return this.day;
    }

    public byte getHour() {
        return this.hour;
    }

    public byte getMinute() {
        return this.minute;
    }

    public byte getMonth() {
        return this.month;
    }

    public byte getPrecision() {
        return this.precision;
    }

    public String getPreferredCalendarModel() {
        return this.preferredCalendarModel;
    }

    public ItemIdValue getPreferredCalendarModelItemId() {
        return null;
    }

    public byte getSecond() {
        return this.second;
    }

    public int getTimezoneOffset() {
        return this.timezoneOffset;
    }

    public long getYear() {
        return this.year;
    }

    public void setAfterTolerance(int afterTolerance) {
        this.afterTolerance = afterTolerance;
    }

    public void setBeforeTolerance(int beforeTolerance) {
        this.beforeTolerance = beforeTolerance;
    }

    public void setDay(byte day) {
        this.day = day;
    }

    public void setHour(byte hour) {
        this.hour = hour;
    }

    public void setMinute(byte minute) {
        this.minute = minute;
    }

    public void setMonth(byte month) {
        this.month = month;
    }

    public void setPrecision(byte precision) {
        this.precision = precision;
    }

    public void setPreferredCalendarModel(String preferredCalendarModel) {
        this.preferredCalendarModel = preferredCalendarModel;
    }

    public void setSecond(byte second) {
        this.second = second;
    }

    public void setTimezoneOffset(int timezoneOffset) {
        this.timezoneOffset = timezoneOffset;
    }

    public void setYear(long year) {
        this.year = year;
    }

    public TimeValue toGregorian() {
        if (this.getPreferredCalendarModel().equals("http://www.wikidata.org/entity/Q1985727")) {
            return this;
        }
        if (this.getPreferredCalendarModel().equals("http://www.wikidata.org/entity/Q1985786") && this.getPrecision() >= 11 && this.year > Integer.MIN_VALUE && this.year < Integer.MAX_VALUE) {
            try {
                JulianDate julian = JulianDate.of((int)((int)this.year), (int)this.month, (int)this.day);
                LocalDate date = LocalDate.from((TemporalAccessor)julian);
                return new TimeValue(date.getYear(), (byte)date.getMonth().getValue(), (byte)date.getDayOfMonth(), this.hour, this.minute, this.second, this.precision, this.beforeTolerance, this.afterTolerance, this.timezoneOffset, "http://www.wikidata.org/entity/Q1985727");
            }
            catch (DateTimeException e) {
                return null;
            }
        }
        return null;
    }
}

