/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.paging;

import de.digitalcollections.model.paging.Direction;
import de.digitalcollections.model.paging.Order;
import de.digitalcollections.model.paging.SortingBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class Sorting
implements Iterable<Order> {
    public static final Direction DEFAULT_DIRECTION = Direction.ASC;
    private List<Order> orders;

    public static SortingBuilder defaultBuilder() {
        return new SortingBuilder();
    }

    public Sorting() {
    }

    public Sorting(Order ... orders) {
        this(Arrays.asList(orders));
    }

    public Sorting(List<Order> orders) {
        if (orders == null) {
            orders = new ArrayList<Order>();
        }
        if ((orders = orders.stream().filter(Objects::nonNull).collect(Collectors.toList())).isEmpty()) {
            throw new IllegalArgumentException("You have to provide at least one sort property to sort by!");
        }
        this.orders = orders;
    }

    public Sorting(String ... properties) {
        this(DEFAULT_DIRECTION, properties);
    }

    public Sorting(Direction direction, String ... properties) {
        this(direction, properties == null ? new ArrayList() : Arrays.asList(properties));
    }

    public Sorting(Direction direction, List<String> properties) {
        if (properties == null || properties.isEmpty()) {
            throw new IllegalArgumentException("You have to provide at least one property to sort by!");
        }
        this.orders = new ArrayList<Order>(properties.size());
        for (String property : properties) {
            this.orders.add(new Order(direction, property));
        }
    }

    public Sorting and(Sorting sort) {
        if (sort == null) {
            return this;
        }
        ArrayList<Order> these = new ArrayList<Order>(this.orders);
        for (Order order : sort) {
            these.add(order);
        }
        return new Sorting(these);
    }

    private String collectionToCommaDelimitedString(List<Order> coll) {
        if (coll == null || coll.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Iterator<Order> it = coll.iterator();
        while (it.hasNext()) {
            sb.append("").append(it.next()).append("");
            if (!it.hasNext()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Sorting)) {
            return false;
        }
        Sorting that = (Sorting)obj;
        return this.orders.equals(that.orders);
    }

    public Order getOrderFor(String property) {
        for (Order order : this) {
            if (!order.getProperty().equals(property)) continue;
            return order;
        }
        return null;
    }

    public List<Order> getOrders() {
        return this.orders;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.orders.hashCode();
        return result;
    }

    @Override
    public Iterator<Order> iterator() {
        return this.orders.iterator();
    }

    public void setOrders(List<Order> orders) {
        if (orders == null) {
            orders = new ArrayList<Order>();
        }
        if ((orders = orders.stream().filter(Objects::nonNull).collect(Collectors.toList())).isEmpty()) {
            throw new IllegalArgumentException("You have to provide at least one sort property to sort by!");
        }
        this.orders = orders;
    }

    public String toString() {
        return this.collectionToCommaDelimitedString(this.orders);
    }
}

