/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.paging;

import de.digitalcollections.model.paging.PageRequest;
import de.digitalcollections.model.paging.Sorting;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class PageResponse<T>
implements Iterable<T> {
    private List<T> content = new ArrayList<T>();
    private PageRequest pageRequest;
    private long total;

    public PageResponse() {
        this.pageRequest = null;
        this.total = 0L;
    }

    public PageResponse(List<T> content, PageRequest pageRequest, long total) {
        assert (content != null) : "content must not be null!";
        this.content.addAll(content);
        this.pageRequest = pageRequest;
        this.total = !content.isEmpty() && pageRequest != null && (long)(pageRequest.getOffset() + pageRequest.getPageSize()) > total ? (long)(pageRequest.getOffset() + content.size()) : total;
    }

    public PageResponse(List<T> content) {
        this(content, null, null == content ? 0L : (long)content.size());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PageResponse)) {
            return false;
        }
        PageResponse that = (PageResponse)obj;
        boolean contentEqual = this.content.equals(that.content);
        boolean pageRequestEqual = this.pageRequest == null ? that.pageRequest == null : this.pageRequest.equals(that.pageRequest);
        return this.total == that.total && contentEqual && pageRequestEqual;
    }

    public List<T> getContent() {
        return Collections.unmodifiableList(this.content);
    }

    public int getNumber() {
        return this.pageRequest == null ? 0 : this.pageRequest.getPageNumber();
    }

    public int getNumberOfElements() {
        return this.content.size();
    }

    public PageRequest getPageRequest() {
        return this.pageRequest;
    }

    public int getSize() {
        return this.pageRequest == null ? 0 : this.pageRequest.getPageSize();
    }

    public Sorting getSorting() {
        return this.pageRequest == null ? null : this.pageRequest.getSorting();
    }

    public long getTotalElements() {
        return this.total;
    }

    public int getTotalPages() {
        return this.getSize() == 0 ? 1 : (int)Math.ceil((double)this.total / (double)this.getSize());
    }

    public boolean hasContent() {
        return !this.content.isEmpty();
    }

    public boolean hasNext() {
        return this.getNumber() + 1 < this.getTotalPages();
    }

    public boolean hasPrevious() {
        return this.getNumber() > 0;
    }

    public int hashCode() {
        int result = 17;
        result += 31 * (int)(this.total ^ this.total >>> 32);
        result += 31 * (this.pageRequest == null ? 0 : this.pageRequest.hashCode());
        return result += 31 * this.content.hashCode();
    }

    public boolean isFirst() {
        return !this.hasPrevious();
    }

    public boolean isLast() {
        return !this.hasNext();
    }

    @Override
    public Iterator<T> iterator() {
        return this.content.iterator();
    }

    public PageRequest nextPageRequest() {
        return this.hasNext() ? this.pageRequest.next() : null;
    }

    public PageRequest previousPageRequest() {
        if (this.hasPrevious()) {
            return this.pageRequest.previousOrFirst();
        }
        return null;
    }

    public void setContent(List<T> content) {
        this.content = content;
    }

    public void setPageRequest(PageRequest pageRequest) {
        this.pageRequest = pageRequest;
    }

    public void setTotalElements(long totalElements) {
        this.total = totalElements;
    }

    public String toString() {
        String contentType = "UNKNOWN";
        List<T> unmodifiableContent = this.getContent();
        if (unmodifiableContent.size() > 0) {
            contentType = unmodifiableContent.get(0).getClass().getName();
        }
        return String.format("Page %s of %d containing %s instances", this.getNumber() + 1, this.getTotalPages(), contentType);
    }
}

