/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.paging;

import de.digitalcollections.model.filter.FilterCriterion;
import de.digitalcollections.model.filter.Filtering;
import de.digitalcollections.model.paging.Direction;
import de.digitalcollections.model.paging.PageRequestBuilder;
import de.digitalcollections.model.paging.Sorting;
import java.io.Serializable;
import java.util.List;

public class PageRequest
implements Serializable {
    private Filtering filtering;
    private int pageNumber;
    private int pageSize;
    private Sorting sort;

    public static PageRequestBuilder defaultBuilder() {
        return new PageRequestBuilder();
    }

    public PageRequest() {
    }

    public PageRequest(int pageNumber, int pageSize) {
        this(pageNumber, pageSize, null, (Filtering)null);
    }

    public PageRequest(int pageNumber, int pageSize, Direction direction, String ... properties) {
        this(pageNumber, pageSize, new Sorting(direction, properties), null);
    }

    public PageRequest(int pageNumber, int pageSize, Sorting sort) {
        this(pageNumber, pageSize, sort, null);
    }

    public PageRequest(int pageNumber, int pageSize, Sorting sort, Filtering filtering) {
        if (pageNumber < 0) {
            throw new IllegalArgumentException("Page index must not be less than zero!");
        }
        if (pageSize < 1) {
            throw new IllegalArgumentException("Page size must not be less than one!");
        }
        this.filtering = filtering;
        this.pageNumber = pageNumber;
        this.pageSize = pageSize;
        this.sort = sort;
    }

    public List<FilterCriterion> add(Filtering filtering) {
        Filtering existingFiltering = this.getFiltering();
        if (existingFiltering == null || existingFiltering.getFilterCriteria().isEmpty()) {
            this.setFiltering(filtering);
        } else {
            existingFiltering.add(filtering);
        }
        return this.getFiltering().getFilterCriteria();
    }

    public boolean equals(Object obj) {
        boolean filterEqual;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PageRequest)) {
            return false;
        }
        PageRequest that = (PageRequest)obj;
        boolean bl = this.filtering == null ? that.filtering == null : (filterEqual = this.filtering.equals(that.filtering));
        boolean sortEqual = this.sort == null ? that.sort == null : this.sort.equals(that.sort);
        boolean othersEqual = this.pageNumber == that.pageNumber && this.pageSize == that.pageSize;
        return filterEqual && othersEqual && sortEqual;
    }

    public PageRequest first() {
        return new PageRequest(0, this.getPageSize(), this.getSorting(), this.getFiltering());
    }

    public Filtering getFiltering() {
        return this.filtering;
    }

    public int getOffset() {
        return this.pageNumber * this.pageSize;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public Sorting getSorting() {
        return this.sort;
    }

    public boolean hasPrevious() {
        return this.pageNumber > 0;
    }

    public boolean hasSorting() {
        return this.sort != null && this.sort.getOrders() != null && !this.sort.getOrders().isEmpty();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.pageNumber;
        result = 31 * result + this.pageSize;
        return 31 * result + (null == this.sort ? 0 : this.sort.hashCode());
    }

    public PageRequest next() {
        return new PageRequest(this.getPageNumber() + 1, this.getPageSize(), this.getSorting());
    }

    public PageRequest previous() {
        return this.getPageNumber() == 0 ? this : new PageRequest(this.getPageNumber() - 1, this.getPageSize(), this.getSorting());
    }

    public PageRequest previousOrFirst() {
        return this.hasPrevious() ? this.previous() : this.first();
    }

    public void setFiltering(Filtering filtering) {
        this.filtering = filtering;
    }

    public void setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void setSorting(Sorting sorting) {
        this.sort = sorting;
    }

    public String toString() {
        return String.format("Page request [number: %d, size %d, sort: %s, filtering: %s]", this.getPageNumber(), this.getPageSize(), this.sort == null ? null : this.sort.toString(), this.filtering == null ? null : this.filtering.toString());
    }
}

