/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.paging;

import de.digitalcollections.model.paging.Direction;
import de.digitalcollections.model.paging.NullHandling;
import de.digitalcollections.model.paging.OrderBuilder;
import de.digitalcollections.model.paging.Sorting;
import java.util.Optional;

public class Order {
    private static final boolean DEFAULT_IGNORE_CASE = false;
    private Direction direction;
    private boolean ignoreCase;
    private NullHandling nullHandling;
    private String property;
    private String subProperty = null;

    public static OrderBuilder defaultBuilder() {
        return new OrderBuilder();
    }

    public Order() {
    }

    public Order(Direction direction, boolean ignoreCase, NullHandling nullHandling, String property) {
        this.direction = direction;
        this.ignoreCase = ignoreCase;
        this.nullHandling = nullHandling;
        this.property = property;
    }

    public Order(Direction direction, String property) {
        this(direction, property, false, null);
    }

    public Order(Direction direction, String property, NullHandling nullHandlingHint) {
        this(direction, property, false, nullHandlingHint);
    }

    public Order(String property) {
        this(Sorting.DEFAULT_DIRECTION, property);
    }

    private Order(Direction direction, String property, boolean ignoreCase, NullHandling nullHandling) {
        if (property == null || property.isEmpty() || property.trim().isEmpty()) {
            throw new IllegalArgumentException("Property must not null or empty!");
        }
        this.direction = direction == null ? Sorting.DEFAULT_DIRECTION : direction;
        this.property = property;
        this.ignoreCase = ignoreCase;
        this.nullHandling = nullHandling == null ? NullHandling.NATIVE : nullHandling;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Order)) {
            return false;
        }
        Order that = (Order)obj;
        return this.direction.equals((Object)that.getDirection()) && this.property.equals(that.getProperty()) && this.ignoreCase == that.isIgnoreCase() && this.nullHandling.equals((Object)that.getNullHandling());
    }

    public Direction getDirection() {
        return this.direction;
    }

    public NullHandling getNullHandling() {
        return this.nullHandling;
    }

    public String getProperty() {
        return this.property;
    }

    public Optional<String> getSubProperty() {
        return Optional.ofNullable(this.subProperty);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.direction.hashCode();
        result = 31 * result + this.property.hashCode();
        result = 31 * result + (this.ignoreCase ? 1 : 0);
        result = 31 * result + this.nullHandling.hashCode();
        return result;
    }

    public Order ignoreCase() {
        return new Order(this.direction, this.property, true, this.nullHandling);
    }

    public boolean isAscending() {
        return this.direction.isAscending();
    }

    public boolean isDescending() {
        return this.direction.isDescending();
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public Order nullsFirst() {
        return this.with(NullHandling.NULLS_FIRST);
    }

    public Order nullsLast() {
        return this.with(NullHandling.NULLS_LAST);
    }

    public Order nullsNative() {
        return this.with(NullHandling.NATIVE);
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    public void setNullHandling(NullHandling nullHandling) {
        this.nullHandling = nullHandling;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public void setSubProperty(String property) {
        this.subProperty = property;
    }

    public String toString() {
        String result = String.format("%s: %s", new Object[]{this.property, this.direction});
        if (!NullHandling.NATIVE.equals((Object)this.nullHandling)) {
            result = result + ", " + (Object)((Object)this.nullHandling);
        }
        if (this.ignoreCase) {
            result = result + ", ignoring case";
        }
        return result;
    }

    public Order with(Direction direction) {
        return new Order(direction, this.property, this.ignoreCase, this.nullHandling);
    }

    public Order with(NullHandling nullHandling) {
        return new Order(this.direction, this.property, this.ignoreCase, nullHandling);
    }

    public Sorting withProperties(String ... properties) {
        return new Sorting(this.direction, properties);
    }

    public Order withProperty(String property) {
        return new Order(this.direction, property, this.ignoreCase, this.nullHandling);
    }
}

