/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.identifiable.resource;

import de.digitalcollections.model.file.MimeType;
import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.identifiable.IdentifiableType;
import de.digitalcollections.model.identifiable.resource.FileResourceType;
import de.digitalcollections.model.legal.License;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Objects;

public class FileResource
extends Identifiable {
    protected FileResourceType fileResourceType;
    private String filename;
    private URL httpBaseUrl;
    private License license;
    private MimeType mimeType;
    private boolean readonly = false;
    private long sizeInBytes;
    private URI uri;

    public FileResource() {
        this.type = IdentifiableType.RESOURCE;
        this.fileResourceType = FileResourceType.UNDEFINED;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof FileResource) {
            FileResource other = (FileResource)obj;
            return Objects.equals(this.filename, other.filename) && Objects.equals((Object)this.fileResourceType, (Object)other.fileResourceType) && Objects.equals(this.mimeType, other.mimeType) && Objects.equals(this.sizeInBytes, other.sizeInBytes) && Objects.equals(this.uri, other.uri);
        }
        return false;
    }

    public FileResourceType getFileResourceType() {
        return this.fileResourceType;
    }

    public String getFilename() {
        if (this.filename == null && this.uri != null) {
            try {
                this.filename = this.uri.toURL().getFile();
                if (this.filename.contains("/")) {
                    this.filename = this.filename.substring(this.filename.lastIndexOf(47) + 1);
                }
                if (this.filename.contains("?")) {
                    this.filename = this.filename.substring(0, this.filename.indexOf(63));
                }
            }
            catch (MalformedURLException ex) {
                this.filename = null;
            }
        }
        return this.filename;
    }

    public String getFilenameExtension() {
        String filename = this.getFilename();
        if (filename == null) {
            return null;
        }
        int lastDotPosition = filename.lastIndexOf(".");
        if (lastDotPosition >= 0 && lastDotPosition < filename.length()) {
            String result = filename.substring(lastDotPosition + 1);
            if (result.trim().length() == 0) {
                return null;
            }
            return result;
        }
        return null;
    }

    public URL getHttpBaseUrl() {
        return this.httpBaseUrl;
    }

    public License getLicense() {
        return this.license;
    }

    public MimeType getMimeType() {
        return this.mimeType;
    }

    public long getSizeInBytes() {
        return this.sizeInBytes;
    }

    public URI getUri() {
        return this.uri;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.filename, this.fileResourceType, this.mimeType, this.sizeInBytes, this.uri});
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setFileResourceType(FileResourceType fileResourceType) {
        this.fileResourceType = fileResourceType;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setHttpBaseUrl(URL httpBaseUrl) {
        this.httpBaseUrl = httpBaseUrl;
    }

    public void setLicense(License license) {
        this.license = license;
    }

    public void setMimeType(MimeType mimeType) {
        this.mimeType = mimeType;
    }

    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
    }

    public void setSizeInBytes(long sizeInBytes) {
        this.sizeInBytes = sizeInBytes;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public String toString() {
        String mimetypeStr = this.getMimeType() == null ? null : this.getMimeType().getTypeName();
        return this.getClass().getSimpleName() + ":\n{\n  uuid=" + String.valueOf(this.getUuid()) + ",\n  uri=" + String.valueOf(this.uri) + ",\n  mimetype=" + mimetypeStr + ",\n  lastModified=" + this.lastModified + "\n}";
    }
}

