/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.filter;

import de.digitalcollections.model.filter.FilterCriterion;
import de.digitalcollections.model.filter.FilterOperation;
import de.digitalcollections.model.filter.FilteringBuilder;
import java.util.Collection;

public class FilterCriterionBuilder {
    private final String fieldName;
    private final FilteringBuilder filteringBuilder;

    FilterCriterionBuilder(String fieldName, FilteringBuilder filteringBuilder) {
        this.filteringBuilder = filteringBuilder;
        this.fieldName = fieldName;
    }

    public FilteringBuilder between(Comparable<?> minValue, Comparable<?> maxValue) {
        FilterCriterion filterCriterion = new FilterCriterion(this.fieldName, FilterOperation.BETWEEN, null, minValue, maxValue, null);
        this.filteringBuilder.add(filterCriterion);
        return this.filteringBuilder;
    }

    public FilteringBuilder contains(Object value) {
        FilterCriterion filterCriterion = new FilterCriterion(this.fieldName, FilterOperation.CONTAINS, value);
        this.filteringBuilder.add(filterCriterion);
        return this.filteringBuilder;
    }

    public FilteringBuilder greater(Object value) {
        FilterCriterion filterCriterion = new FilterCriterion(this.fieldName, FilterOperation.GREATER_THAN, value);
        this.filteringBuilder.add(filterCriterion);
        return this.filteringBuilder;
    }

    public FilteringBuilder greaterOrEqual(Object value) {
        FilterCriterion filterCriterion = new FilterCriterion(this.fieldName, FilterOperation.GREATER_THAN_OR_EQUAL_TO, value);
        this.filteringBuilder.add(filterCriterion);
        return this.filteringBuilder;
    }

    public FilteringBuilder greaterOrEqualOrNotSet(Object value) {
        FilterCriterion filterCriterion = new FilterCriterion(this.fieldName, FilterOperation.GREATER_THAN_OR_EQUAL_TO_OR_NOT_SET, value);
        this.filteringBuilder.add(filterCriterion);
        return this.filteringBuilder;
    }

    public FilteringBuilder greaterOrNotSet(Object value) {
        FilterCriterion filterCriterion = new FilterCriterion(this.fieldName, FilterOperation.GREATER_THAN_OR_NOT_SET, value);
        this.filteringBuilder.add(filterCriterion);
        return this.filteringBuilder;
    }

    public FilteringBuilder in(Collection<?> values) {
        FilterCriterion filterCriterion = new FilterCriterion(this.fieldName, FilterOperation.IN, null, null, null, values);
        this.filteringBuilder.add(filterCriterion);
        return this.filteringBuilder;
    }

    public FilteringBuilder isEquals(Object value) {
        FilterCriterion filterCriterion = new FilterCriterion(this.fieldName, FilterOperation.EQUALS, value);
        this.filteringBuilder.add(filterCriterion);
        return this.filteringBuilder;
    }

    public FilteringBuilder isEqualsOrNotSet(Object value) {
        FilterCriterion filterCriterion = new FilterCriterion(this.fieldName, FilterOperation.EQUALS_OR_NOT_SET, value);
        this.filteringBuilder.add(filterCriterion);
        return this.filteringBuilder;
    }

    public FilteringBuilder less(Object value) {
        FilterCriterion filterCriterion = new FilterCriterion(this.fieldName, FilterOperation.LESS_THAN, value);
        this.filteringBuilder.add(filterCriterion);
        return this.filteringBuilder;
    }

    public FilteringBuilder lessAndSet(Object value) {
        FilterCriterion filterCriterion = new FilterCriterion(this.fieldName, FilterOperation.LESS_THAN_AND_SET, value);
        this.filteringBuilder.add(filterCriterion);
        return this.filteringBuilder;
    }

    public FilteringBuilder lessOrEqual(Object value) {
        FilterCriterion filterCriterion = new FilterCriterion(this.fieldName, FilterOperation.LESS_THAN_OR_EQUAL_TO, value);
        this.filteringBuilder.add(filterCriterion);
        return this.filteringBuilder;
    }

    public FilteringBuilder lessOrEqualAndSet(Object value) {
        FilterCriterion filterCriterion = new FilterCriterion(this.fieldName, FilterOperation.LESS_THAN_OR_EQUAL_TO_AND_SET, value);
        this.filteringBuilder.add(filterCriterion);
        return this.filteringBuilder;
    }

    public FilteringBuilder lessOrEqualOrNotSet(Object value) {
        FilterCriterion filterCriterion = new FilterCriterion(this.fieldName, FilterOperation.LESS_THAN_OR_EQUAL_TO_OR_NOT_SET, value);
        this.filteringBuilder.add(filterCriterion);
        return this.filteringBuilder;
    }

    public FilteringBuilder lessOrNotSet(Object value) {
        FilterCriterion filterCriterion = new FilterCriterion(this.fieldName, FilterOperation.LESS_THAN_OR_NOT_SET, value);
        this.filteringBuilder.add(filterCriterion);
        return this.filteringBuilder;
    }

    public FilteringBuilder notEquals(Object value) {
        FilterCriterion filterCriterion = new FilterCriterion(this.fieldName, FilterOperation.NOT_EQUALS, value);
        this.filteringBuilder.add(filterCriterion);
        return this.filteringBuilder;
    }

    public FilteringBuilder notIn(Collection<?> values) {
        FilterCriterion filterCriterion = new FilterCriterion(this.fieldName, FilterOperation.NOT_IN, null, null, null, values);
        this.filteringBuilder.add(filterCriterion);
        return this.filteringBuilder;
    }

    public FilteringBuilder notSet() {
        FilterCriterion filterCriterion = new FilterCriterion(this.fieldName, FilterOperation.NOT_SET, null);
        this.filteringBuilder.add(filterCriterion);
        return this.filteringBuilder;
    }

    public FilteringBuilder set() {
        FilterCriterion filterCriterion = new FilterCriterion(this.fieldName, FilterOperation.SET, null);
        this.filteringBuilder.add(filterCriterion);
        return this.filteringBuilder;
    }

    public FilteringBuilder startsWith(Object value) {
        FilterCriterion filterCriterion = new FilterCriterion(this.fieldName, FilterOperation.STARTS_WITH, value);
        this.filteringBuilder.add(filterCriterion);
        return this.filteringBuilder;
    }
}

