/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.file;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;

public class MimeType {
    private static Map<String, MimeType> knownTypes;
    private static Map<String, String> extensionMapping;
    private static final Pattern MIME_PATTERN;
    public static final MimeType MIME_WILDCARD;
    public static final MimeType MIME_IMAGE;
    public static final MimeType MIME_APPLICATION_JSON;
    public static final MimeType MIME_APPLICATION_OCTET_STREAM;
    public static final MimeType MIME_APPLICATION_XML;
    public static final MimeType MIME_IMAGE_JPEG;
    public static final MimeType MIME_IMAGE_TIF;
    public static final MimeType MIME_IMAGE_PNG;
    public static final MimeType MIME_TYPE_MARKDOWN;
    private final String primaryType;
    private final String subType;
    private final String suffix;
    private List<String> extensions;

    private static String getMimeTypeColumn(String line) {
        return Arrays.stream(line.split("\t")).map(String::strip).filter(Predicate.not(String::isEmpty)).findFirst().orElseThrow(NoSuchElementException::new);
    }

    public static MimeType fromExtension(String ext) {
        String extension = ext.startsWith(".") ? ext.substring(1).toLowerCase() : ext.toLowerCase();
        String typeName = extensionMapping.get(extension);
        if (typeName != null) {
            return knownTypes.get(typeName);
        }
        return null;
    }

    public static MimeType fromFilename(String filename) {
        return MimeType.fromExtension(FilenameUtils.getExtension((String)filename));
    }

    public static MimeType fromURI(URI uri) {
        try {
            return MimeType.fromFilename(Paths.get(uri).toString());
        }
        catch (FileSystemNotFoundException e) {
            return MimeType.fromExtension(FilenameUtils.getExtension((String)uri.toString()));
        }
    }

    public static MimeType fromTypename(String typeName) {
        MimeType knownType = knownTypes.get(typeName);
        if (knownType != null) {
            return knownType;
        }
        MimeType unknownType = new MimeType(typeName);
        if (!(unknownType.getPrimaryType().startsWith("x-") && unknownType.getSubType().startsWith("vnd.") && unknownType.getSubType().startsWith("prs."))) {
            return null;
        }
        return unknownType;
    }

    private MimeType(String typeName) {
        this(typeName, Collections.emptyList());
    }

    private MimeType(String typeName, List<String> extensions) {
        if (typeName.equals("*")) {
            this.primaryType = "*";
            this.subType = "*";
            this.suffix = "";
        } else {
            Matcher matcher = MIME_PATTERN.matcher(typeName);
            if (!matcher.matches()) {
                throw new IllegalArgumentException(String.format("%s is not a valid MIME type!", typeName));
            }
            this.primaryType = matcher.group("primaryType");
            this.subType = matcher.group("subType");
            this.suffix = matcher.group("suffix");
            this.extensions = extensions;
        }
    }

    public String getTypeName() {
        StringBuilder sb = new StringBuilder(this.primaryType).append("/").append(this.subType);
        if (this.suffix != null) {
            sb.append("+").append(this.suffix);
        }
        return sb.toString();
    }

    public List<String> getExtensions() {
        return this.extensions;
    }

    private void setExtensions(List<String> extensions) {
        this.extensions = extensions;
    }

    public String getPrimaryType() {
        return this.primaryType;
    }

    public String getSubType() {
        return this.subType;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public boolean matches(Object other) {
        if (other instanceof MimeType) {
            MimeType mime = (MimeType)other;
            if (mime == MIME_WILDCARD || this == MIME_WILDCARD) {
                return true;
            }
            if ((mime.getSubType().equals("*") || this.getSubType().equals("*")) && this.getPrimaryType().equals(mime.getPrimaryType())) {
                return true;
            }
            return super.equals(other);
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == null || !obj.getClass().isAssignableFrom(MimeType.class)) {
            return false;
        }
        return this.hashCode() == ((MimeType)obj).hashCode();
    }

    public int hashCode() {
        int hash = 3;
        hash = 37 * hash + Objects.hashCode(this.getTypeName());
        return hash;
    }

    public String toString() {
        return this.getTypeName();
    }

    static {
        MIME_PATTERN = Pattern.compile("^(?<primaryType>[-a-z]+?)/(?<subType>[-\\\\.a-z0-9*]+?)(?:\\+(?<suffix>\\w+))?$");
        InputStream mimeStream = MimeType.class.getClassLoader().getResourceAsStream("dc.mime.types");
        BufferedReader mimeReader = new BufferedReader(new InputStreamReader(mimeStream));
        Function<String[], String[]> substituteMissingExtensions = columns -> {
            if (((String[])columns).length > 1) {
                return columns;
            }
            return new String[]{columns[0], ""};
        };
        knownTypes = mimeReader.lines().map(l -> l.replaceAll("^# ", "")).filter(l -> !l.isEmpty()).map(line -> line.split("\t+")).filter(columns -> ((String[])columns).length > 0).filter(columns -> MIME_PATTERN.matcher(columns[0]).matches()).map(substituteMissingExtensions).collect(Collectors.toMap(columns -> columns[0], columns -> new MimeType(columns[0], "".equals(columns[1]) ? Collections.emptyList() : List.of(columns[1].split(" ")))));
        knownTypes.get("image/jpeg").setExtensions(Arrays.asList("jpg", "jpeg", "jpe"));
        knownTypes.get("image/tiff").setExtensions(Arrays.asList("tif", "tiff"));
        ArrayList<String> xmlExtensions = new ArrayList<String>(knownTypes.get("application/xml").getExtensions());
        xmlExtensions.add("ent");
        knownTypes.get("application/xml").setExtensions(xmlExtensions);
        knownTypes.put("audio/*", new MimeType("audio/*", Collections.emptyList()));
        knownTypes.put("image/*", new MimeType("image/*", Collections.emptyList()));
        knownTypes.put("text/*", new MimeType("text/*", Collections.emptyList()));
        knownTypes.put("video/*", new MimeType("video/*", Collections.emptyList()));
        extensionMapping = new HashMap<String, String>();
        for (Map.Entry<String, MimeType> entry : knownTypes.entrySet()) {
            String typeName = entry.getKey();
            for (String ext : entry.getValue().getExtensions()) {
                extensionMapping.put(ext, typeName);
            }
        }
        MIME_WILDCARD = new MimeType("*", Collections.emptyList());
        MIME_IMAGE = knownTypes.get("image/*");
        MIME_APPLICATION_JSON = knownTypes.get("application/json");
        MIME_APPLICATION_OCTET_STREAM = knownTypes.get("application/octet-stream");
        MIME_APPLICATION_XML = knownTypes.get("application/xml");
        MIME_IMAGE_JPEG = knownTypes.get("image/jpeg");
        MIME_IMAGE_TIF = knownTypes.get("image/tiff");
        MIME_IMAGE_PNG = knownTypes.get("image/png");
        MIME_TYPE_MARKDOWN = knownTypes.get("text/markdown");
    }
}

