/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.impl.paging;

import de.digitalcollections.model.api.paging.Order;
import de.digitalcollections.model.api.paging.Sorting;
import de.digitalcollections.model.api.paging.enums.Direction;
import de.digitalcollections.model.api.paging.enums.NullHandling;
import de.digitalcollections.model.impl.paging.SortingImpl;
import java.util.Optional;

public class OrderImpl
implements Order {
    private static final boolean DEFAULT_IGNORE_CASE = false;
    private Direction direction;
    private boolean ignoreCase;
    private NullHandling nullHandling;
    private String property;
    private String subProperty = null;

    public OrderImpl() {
    }

    public OrderImpl(Direction direction, boolean ignoreCase, NullHandling nullHandling, String property) {
        this.direction = direction;
        this.ignoreCase = ignoreCase;
        this.nullHandling = nullHandling;
        this.property = property;
    }

    public OrderImpl(Direction direction, String property) {
        this(direction, property, false, null);
    }

    public OrderImpl(Direction direction, String property, NullHandling nullHandlingHint) {
        this(direction, property, false, nullHandlingHint);
    }

    public OrderImpl(String property) {
        this(Sorting.DEFAULT_DIRECTION, property);
    }

    private OrderImpl(Direction direction, String property, boolean ignoreCase, NullHandling nullHandling) {
        if (property == null || property.isEmpty() || property.trim().isEmpty()) {
            throw new IllegalArgumentException("Property must not null or empty!");
        }
        this.direction = direction == null ? Sorting.DEFAULT_DIRECTION : direction;
        this.property = property;
        this.ignoreCase = ignoreCase;
        this.nullHandling = nullHandling == null ? NullHandling.NATIVE : nullHandling;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OrderImpl)) {
            return false;
        }
        OrderImpl that = (OrderImpl)obj;
        return this.direction.equals((Object)that.getDirection()) && this.property.equals(that.getProperty()) && this.ignoreCase == that.isIgnoreCase() && this.nullHandling.equals((Object)that.getNullHandling());
    }

    @Override
    public Direction getDirection() {
        return this.direction;
    }

    @Override
    public NullHandling getNullHandling() {
        return this.nullHandling;
    }

    @Override
    public String getProperty() {
        return this.property;
    }

    @Override
    public Optional<String> getSubProperty() {
        return Optional.ofNullable(this.subProperty);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.direction.hashCode();
        result = 31 * result + this.property.hashCode();
        result = 31 * result + (this.ignoreCase ? 1 : 0);
        result = 31 * result + this.nullHandling.hashCode();
        return result;
    }

    @Override
    public Order ignoreCase() {
        return new OrderImpl(this.direction, this.property, true, this.nullHandling);
    }

    @Override
    public boolean isAscending() {
        return this.direction.isAscending();
    }

    @Override
    public boolean isDescending() {
        return this.direction.isDescending();
    }

    @Override
    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    @Override
    public Order nullsFirst() {
        return this.with(NullHandling.NULLS_FIRST);
    }

    @Override
    public Order nullsLast() {
        return this.with(NullHandling.NULLS_LAST);
    }

    @Override
    public Order nullsNative() {
        return this.with(NullHandling.NATIVE);
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    public void setNullHandling(NullHandling nullHandling) {
        this.nullHandling = nullHandling;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public void setSubProperty(String property) {
        this.subProperty = property;
    }

    public String toString() {
        String result = String.format("%s: %s", new Object[]{this.property, this.direction});
        if (!NullHandling.NATIVE.equals((Object)this.nullHandling)) {
            result = result + ", " + (Object)((Object)this.nullHandling);
        }
        if (this.ignoreCase) {
            result = result + ", ignoring case";
        }
        return result;
    }

    @Override
    public Order with(Direction direction) {
        return new OrderImpl(direction, this.property, this.ignoreCase, this.nullHandling);
    }

    @Override
    public Order with(NullHandling nullHandling) {
        return new OrderImpl(this.direction, this.property, this.ignoreCase, nullHandling);
    }

    @Override
    public Sorting withProperties(String ... properties) {
        return new SortingImpl(this.direction, properties);
    }

    @Override
    public Order withProperty(String property) {
        return new OrderImpl(this.direction, property, this.ignoreCase, this.nullHandling);
    }
}

