/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.impl.identifiable.parts;

import de.digitalcollections.model.api.identifiable.parts.Translation;
import java.util.Locale;
import java.util.Objects;

public class TranslationImpl
implements Translation {
    private Locale locale;
    private String text;

    private TranslationImpl() {
    }

    public TranslationImpl(Locale locale, String text) {
        if (locale == null) {
            throw new IllegalArgumentException("Locale must not be null!");
        }
        this.text = text;
        this.locale = locale;
    }

    public TranslationImpl(Translation translation) {
        this(translation.getLocale(), translation.getText());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TranslationImpl) {
            TranslationImpl other = (TranslationImpl)obj;
            return Objects.equals(this.text, other.getText()) && Objects.equals(this.locale, other.getLocale());
        }
        return false;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public void setLocale(Locale locale) {
        if (locale == null) {
            throw new IllegalArgumentException("Locale must not be null!");
        }
        this.locale = locale;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void setText(String text) {
        this.text = text;
    }

    @Override
    public boolean has(Locale locale) {
        return Objects.equals(this.locale, locale);
    }

    public int hashCode() {
        return Objects.hash(this.text, this.locale);
    }

    public String toString() {
        return "Translation {locale: '" + this.locale + "', text: '" + this.text + '}';
    }
}

