/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.api.paging;

import de.digitalcollections.model.api.filter.FilterCriterion;
import de.digitalcollections.model.api.filter.Filtering;
import de.digitalcollections.model.api.paging.Sorting;
import de.digitalcollections.model.impl.paging.PageRequestImpl;
import java.util.List;

public interface PageRequest {
    public static Builder defaultBuilder() {
        return new Builder();
    }

    default public List<FilterCriterion> add(Filtering filtering) {
        Filtering existingFiltering = this.getFiltering();
        if (existingFiltering == null || existingFiltering.getFilterCriteria().isEmpty()) {
            this.setFiltering(filtering);
        } else {
            existingFiltering.add(filtering);
        }
        return this.getFiltering().getFilterCriteria();
    }

    public PageRequest first();

    public Filtering getFiltering();

    public int getOffset();

    public int getPageNumber();

    public int getPageSize();

    public Sorting getSorting();

    public boolean hasPrevious();

    public boolean hasSorting();

    public PageRequest next();

    public PageRequest previousOrFirst();

    public void setFiltering(Filtering var1);

    public void setPageNumber(int var1);

    public void setPageSize(int var1);

    public void setSorting(Sorting var1);

    public static class Builder {
        private int pageNumber;
        private int pageSize;
        private Sorting sorting;
        private Filtering filtering;

        public Builder pageNumber(int pageNumber) {
            this.pageNumber = pageNumber;
            return this;
        }

        public Builder pageSize(int pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Builder sorting(Sorting sorting) {
            this.sorting = sorting;
            return this;
        }

        public Builder filtering(Filtering filtering) {
            this.filtering = filtering;
            return this;
        }

        public PageRequest build() {
            return new PageRequestImpl(this.pageNumber, this.pageSize, this.sorting, this.filtering);
        }
    }
}

