/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.api.paging;

import de.digitalcollections.model.api.paging.Sorting;
import de.digitalcollections.model.api.paging.enums.Direction;
import de.digitalcollections.model.api.paging.enums.NullHandling;
import de.digitalcollections.model.impl.paging.OrderImpl;
import java.util.Optional;

public interface Order {
    public static Builder defaultBuilder() {
        return new Builder();
    }

    public Direction getDirection();

    public NullHandling getNullHandling();

    public String getProperty();

    public Optional<String> getSubProperty();

    public Order ignoreCase();

    public boolean isAscending();

    public boolean isDescending();

    public boolean isIgnoreCase();

    public Order nullsFirst();

    public Order nullsLast();

    public Order nullsNative();

    public Order with(Direction var1);

    public Order with(NullHandling var1);

    public Sorting withProperties(String ... var1);

    public Order withProperty(String var1);

    public static class Builder {
        private Direction direction;
        private boolean ignoreCase;
        private NullHandling nullHandling;
        private String property;
        private String subProperty;

        public Builder direction(Direction direction) {
            this.direction = direction;
            return this;
        }

        public Builder ignoreCase(boolean ignoreCase) {
            this.ignoreCase = ignoreCase;
            return this;
        }

        public Builder nullHandling(NullHandling nullHandling) {
            this.nullHandling = nullHandling;
            return this;
        }

        public Builder property(String property) {
            this.property = property;
            return this;
        }

        public Builder subProperty(String property) {
            this.subProperty = property;
            return this;
        }

        public Order build() {
            OrderImpl order = new OrderImpl(this.direction, this.ignoreCase, this.nullHandling, this.property);
            if (this.subProperty != null) {
                order.setSubProperty(this.subProperty);
            }
            return order;
        }
    }
}

