/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.api.filter.enums;

public enum FilterOperation {
    EQUALS("eq", OperandCount.SINGLEVALUE),
    EQUALS_OR_NOT_SET("eq_notset", OperandCount.SINGLEVALUE),
    NOT_EQUALS("neq", OperandCount.SINGLEVALUE),
    GREATER_THAN("gt", OperandCount.SINGLEVALUE),
    GREATER_THAN_OR_NOT_SET("gt_notset", OperandCount.SINGLEVALUE),
    GREATER_THAN_OR_EQUAL_TO("gte", OperandCount.SINGLEVALUE),
    GREATER_THAN_OR_EQUAL_TO_OR_NOT_SET("gte_notset", OperandCount.SINGLEVALUE),
    LESS_THAN("lt", OperandCount.SINGLEVALUE),
    LESS_THAN_AND_SET("lt_set", OperandCount.SINGLEVALUE),
    LESS_THAN_OR_NOT_SET("lt_notset", OperandCount.SINGLEVALUE),
    LESS_THAN_OR_EQUAL_TO("lte", OperandCount.SINGLEVALUE),
    LESS_THAN_OR_EQUAL_TO_AND_SET("lte_set", OperandCount.SINGLEVALUE),
    LESS_THAN_OR_EQUAL_TO_OR_NOT_SET("lte_notset", OperandCount.SINGLEVALUE),
    IN("in", OperandCount.MULTIVALUE),
    NOT_IN("nin", OperandCount.MULTIVALUE),
    BETWEEN("btn", OperandCount.MIN_MAX_VALUES),
    CONTAINS("like", OperandCount.SINGLEVALUE),
    NOT_SET("notset", OperandCount.NO_VALUE),
    SET("set", OperandCount.NO_VALUE),
    STARTS_WITH("stw", OperandCount.SINGLEVALUE);

    private final String value;
    private final OperandCount opCount;

    public OperandCount getOperandCount() {
        return this.opCount;
    }

    private FilterOperation(String value, OperandCount opCount) {
        this.value = value;
        this.opCount = opCount;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FilterOperation fromValue(String value) {
        for (FilterOperation op : FilterOperation.values()) {
            if (!String.valueOf(op.value).equalsIgnoreCase(value)) continue;
            return op;
        }
        return null;
    }

    public static enum OperandCount {
        SINGLEVALUE,
        MIN_MAX_VALUES,
        MULTIVALUE,
        NO_VALUE;

    }
}

