/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.api.filter;

import de.digitalcollections.model.api.filter.FilterCriterion;
import de.digitalcollections.model.api.filter.enums.FilterOperation;
import de.digitalcollections.model.impl.filter.FilteringImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public interface Filtering
extends Iterable<FilterCriterion>,
Serializable {
    default public List<FilterCriterion> add(Filtering filtering) {
        if (filtering == null || filtering.getFilterCriteria() == null) {
            return this.getFilterCriteria();
        }
        if (this.getFilterCriteria() == null) {
            this.setFilterCriteria(filtering.getFilterCriteria());
            return this.getFilterCriteria();
        }
        ArrayList<FilterCriterion> mergedList = new ArrayList<FilterCriterion>(this.getFilterCriteria());
        mergedList.addAll(filtering.getFilterCriteria());
        this.setFilterCriteria(mergedList);
        return this.getFilterCriteria();
    }

    public FilterCriterion getFilterCriterionFor(String var1);

    public List<FilterCriterion> getFilterCriteria();

    public void setFilterCriteria(List<FilterCriterion> var1);

    public static FilteringBuilder defaultBuilder() {
        return new FilteringBuilder();
    }

    public static class FilteringBuilder {
        private final List<FilterCriterion> filterCriterias = new ArrayList<FilterCriterion>();

        public FilterCriterionBuilder filter(String fieldName) {
            return new FilterCriterionBuilder(fieldName, this);
        }

        public FilteringBuilder add(String fieldName, FilterCriterion filterCriterion) {
            if (filterCriterion != null) {
                filterCriterion.setFieldName(fieldName);
            }
            return this.add(filterCriterion);
        }

        public FilteringBuilder add(FilterCriterion filterCriterion) {
            if (filterCriterion != null) {
                if (filterCriterion.getFieldName() == null) {
                    throw new IllegalArgumentException("field name of a filter criterion must not be null!");
                }
                this.filterCriterias.add(filterCriterion);
            }
            return this;
        }

        public Filtering build() {
            return new FilteringImpl(this.filterCriterias);
        }
    }

    public static class FilterCriterionBuilder {
        private final FilteringBuilder filteringBuilder;
        private final String fieldName;

        private FilterCriterionBuilder(String fieldName, FilteringBuilder filteringBuilder) {
            this.filteringBuilder = filteringBuilder;
            this.fieldName = fieldName;
        }

        public FilteringBuilder between(Comparable<?> minValue, Comparable<?> maxValue) {
            FilterCriterion filterCriterion = new FilterCriterion(this.fieldName, FilterOperation.BETWEEN, null, minValue, maxValue, null);
            this.filteringBuilder.add(filterCriterion);
            return this.filteringBuilder;
        }

        public FilteringBuilder contains(Object value) {
            FilterCriterion filterCriterion = new FilterCriterion(this.fieldName, FilterOperation.CONTAINS, value);
            this.filteringBuilder.add(filterCriterion);
            return this.filteringBuilder;
        }

        public FilteringBuilder isEquals(Object value) {
            FilterCriterion filterCriterion = new FilterCriterion(this.fieldName, FilterOperation.EQUALS, value);
            this.filteringBuilder.add(filterCriterion);
            return this.filteringBuilder;
        }

        public FilteringBuilder isEqualsOrNotSet(Object value) {
            FilterCriterion filterCriterion = new FilterCriterion(this.fieldName, FilterOperation.EQUALS_OR_NOT_SET, value);
            this.filteringBuilder.add(filterCriterion);
            return this.filteringBuilder;
        }

        public FilteringBuilder greater(Object value) {
            FilterCriterion filterCriterion = new FilterCriterion(this.fieldName, FilterOperation.GREATER_THAN, value);
            this.filteringBuilder.add(filterCriterion);
            return this.filteringBuilder;
        }

        public FilteringBuilder greaterOrNotSet(Object value) {
            FilterCriterion filterCriterion = new FilterCriterion(this.fieldName, FilterOperation.GREATER_THAN_OR_NOT_SET, value);
            this.filteringBuilder.add(filterCriterion);
            return this.filteringBuilder;
        }

        public FilteringBuilder greaterOrEqual(Object value) {
            FilterCriterion filterCriterion = new FilterCriterion(this.fieldName, FilterOperation.GREATER_THAN_OR_EQUAL_TO, value);
            this.filteringBuilder.add(filterCriterion);
            return this.filteringBuilder;
        }

        public FilteringBuilder greaterOrEqualOrNotSet(Object value) {
            FilterCriterion filterCriterion = new FilterCriterion(this.fieldName, FilterOperation.GREATER_THAN_OR_EQUAL_TO_OR_NOT_SET, value);
            this.filteringBuilder.add(filterCriterion);
            return this.filteringBuilder;
        }

        public FilteringBuilder in(Collection<?> values) {
            FilterCriterion filterCriterion = new FilterCriterion(this.fieldName, FilterOperation.IN, null, null, null, values);
            this.filteringBuilder.add(filterCriterion);
            return this.filteringBuilder;
        }

        public FilteringBuilder less(Object value) {
            FilterCriterion filterCriterion = new FilterCriterion(this.fieldName, FilterOperation.LESS_THAN, value);
            this.filteringBuilder.add(filterCriterion);
            return this.filteringBuilder;
        }

        public FilteringBuilder lessAndSet(Object value) {
            FilterCriterion filterCriterion = new FilterCriterion(this.fieldName, FilterOperation.LESS_THAN_AND_SET, value);
            this.filteringBuilder.add(filterCriterion);
            return this.filteringBuilder;
        }

        public FilteringBuilder lessOrNotSet(Object value) {
            FilterCriterion filterCriterion = new FilterCriterion(this.fieldName, FilterOperation.LESS_THAN_OR_NOT_SET, value);
            this.filteringBuilder.add(filterCriterion);
            return this.filteringBuilder;
        }

        public FilteringBuilder lessOrEqual(Object value) {
            FilterCriterion filterCriterion = new FilterCriterion(this.fieldName, FilterOperation.LESS_THAN_OR_EQUAL_TO, value);
            this.filteringBuilder.add(filterCriterion);
            return this.filteringBuilder;
        }

        public FilteringBuilder lessOrEqualAndSet(Object value) {
            FilterCriterion filterCriterion = new FilterCriterion(this.fieldName, FilterOperation.LESS_THAN_OR_EQUAL_TO_AND_SET, value);
            this.filteringBuilder.add(filterCriterion);
            return this.filteringBuilder;
        }

        public FilteringBuilder lessOrEqualOrNotSet(Object value) {
            FilterCriterion filterCriterion = new FilterCriterion(this.fieldName, FilterOperation.LESS_THAN_OR_EQUAL_TO_OR_NOT_SET, value);
            this.filteringBuilder.add(filterCriterion);
            return this.filteringBuilder;
        }

        public FilteringBuilder notEquals(Object value) {
            FilterCriterion filterCriterion = new FilterCriterion(this.fieldName, FilterOperation.NOT_EQUALS, value);
            this.filteringBuilder.add(filterCriterion);
            return this.filteringBuilder;
        }

        public FilteringBuilder notIn(Collection<?> values) {
            FilterCriterion filterCriterion = new FilterCriterion(this.fieldName, FilterOperation.NOT_IN, null, null, null, values);
            this.filteringBuilder.add(filterCriterion);
            return this.filteringBuilder;
        }

        public FilteringBuilder notSet() {
            FilterCriterion filterCriterion = new FilterCriterion(this.fieldName, FilterOperation.NOT_SET, null);
            this.filteringBuilder.add(filterCriterion);
            return this.filteringBuilder;
        }

        public FilteringBuilder set() {
            FilterCriterion filterCriterion = new FilterCriterion(this.fieldName, FilterOperation.SET, null);
            this.filteringBuilder.add(filterCriterion);
            return this.filteringBuilder;
        }

        public FilteringBuilder startsWith(Object value) {
            FilterCriterion filterCriterion = new FilterCriterion(this.fieldName, FilterOperation.STARTS_WITH, value);
            this.filteringBuilder.add(filterCriterion);
            return this.filteringBuilder;
        }
    }
}

