/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.impl.identifiable;

import de.digitalcollections.model.api.identifiable.Identifiable;
import de.digitalcollections.model.api.identifiable.IdentifiableType;
import de.digitalcollections.model.api.identifiable.Identifier;
import de.digitalcollections.model.api.identifiable.parts.LocalizedText;
import de.digitalcollections.model.api.identifiable.parts.RenderingHintsPreviewImage;
import de.digitalcollections.model.api.identifiable.parts.structuredcontent.LocalizedStructuredContent;
import de.digitalcollections.model.api.identifiable.resource.ImageFileResource;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;

public class IdentifiableImpl
implements Identifiable {
    protected LocalDateTime created;
    protected LocalizedStructuredContent description;
    private Set<Identifier> identifiers = new HashSet<Identifier>();
    protected LocalizedText label;
    protected LocalDateTime lastModified;
    protected ImageFileResource previewImage;
    protected RenderingHintsPreviewImage previewImageRenderingHints;
    protected IdentifiableType type;
    private UUID uuid;

    @Override
    public LocalDateTime getCreated() {
        return this.created;
    }

    @Override
    public void setCreated(LocalDateTime created) {
        this.created = created;
    }

    @Override
    public LocalizedStructuredContent getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(LocalizedStructuredContent description) {
        this.description = description;
    }

    @Override
    public void addIdentifier(Identifier identifier) {
        this.identifiers.add(Objects.requireNonNull(identifier));
    }

    @Override
    public Identifier getIdentifierByNamespace(String namespace) {
        if (namespace == null || this.identifiers == null || this.identifiers.isEmpty()) {
            return null;
        }
        for (Identifier identifier : this.identifiers) {
            if (!namespace.equals(identifier.getNamespace())) continue;
            return identifier;
        }
        return null;
    }

    @Override
    public Set<Identifier> getIdentifiers() {
        return this.identifiers;
    }

    @Override
    public void setIdentifiers(Set<Identifier> identifiers) {
        this.identifiers = identifiers;
    }

    @Override
    public LocalizedText getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(LocalizedText label) {
        this.label = label;
    }

    @Override
    public LocalDateTime getLastModified() {
        return this.lastModified;
    }

    @Override
    public void setLastModified(LocalDateTime lastModified) {
        this.lastModified = lastModified;
    }

    @Override
    public ImageFileResource getPreviewImage() {
        return this.previewImage;
    }

    @Override
    public void setPreviewImage(ImageFileResource previewImage) {
        this.previewImage = previewImage;
    }

    @Override
    public IdentifiableType getType() {
        return this.type;
    }

    @Override
    public void setType(IdentifiableType identifiableType) {
        this.type = identifiableType;
    }

    @Override
    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    @Override
    public RenderingHintsPreviewImage getPreviewImageRenderingHints() {
        return this.previewImageRenderingHints;
    }

    @Override
    public void setPreviewImageRenderingHints(RenderingHintsPreviewImage previewImageRenderingHints) {
        this.previewImageRenderingHints = previewImageRenderingHints;
    }
}

