/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.api.paging;

import de.digitalcollections.model.api.filter.Filtering;
import de.digitalcollections.model.api.paging.Sorting;
import de.digitalcollections.model.impl.paging.PageRequestImpl;

public interface PageRequest {
    public static Builder defaultBuilder() {
        return new Builder();
    }

    public PageRequest first();

    public void setFiltering(Filtering var1);

    public Filtering getFiltering();

    public int getOffset();

    public void setPageNumber(int var1);

    public int getPageNumber();

    public void setPageSize(int var1);

    public int getPageSize();

    public void setSorting(Sorting var1);

    public Sorting getSorting();

    public boolean hasPrevious();

    public PageRequest next();

    public PageRequest previousOrFirst();

    public static class Builder {
        private int pageNumber;
        private int pageSize;
        private Sorting sorting;
        private Filtering filtering;

        public Builder pageNumber(int pageNumber) {
            this.pageNumber = pageNumber;
            return this;
        }

        public Builder pageSize(int pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Builder sorting(Sorting sorting) {
            this.sorting = sorting;
            return this;
        }

        public Builder filtering(Filtering filtering) {
            this.filtering = filtering;
            return this;
        }

        public PageRequest build() {
            return new PageRequestImpl(this.pageNumber, this.pageSize, this.sorting, this.filtering);
        }
    }
}

