/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.impl.paging;

import de.digitalcollections.model.api.filter.Filtering;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.Sorting;
import de.digitalcollections.model.api.paging.enums.Direction;
import de.digitalcollections.model.impl.paging.SortingImpl;
import java.io.Serializable;

public class PageRequestImpl
implements PageRequest,
Serializable {
    private int pageNumber;
    private int pageSize;
    private Filtering filtering;
    private Sorting sort;

    public PageRequestImpl() {
    }

    public PageRequestImpl(int pageNumber, int pageSize) {
        this(pageNumber, pageSize, null, (Filtering)null);
    }

    public PageRequestImpl(int pageNumber, int pageSize, Direction direction, String ... properties) {
        this(pageNumber, pageSize, new SortingImpl(direction, properties), null);
    }

    public PageRequestImpl(int pageNumber, int pageSize, Sorting sort) {
        this(pageNumber, pageSize, sort, null);
    }

    public PageRequestImpl(int pageNumber, int pageSize, Sorting sort, Filtering filtering) {
        if (pageNumber < 0) {
            throw new IllegalArgumentException("Page index must not be less than zero!");
        }
        if (pageSize < 1) {
            throw new IllegalArgumentException("Page size must not be less than one!");
        }
        this.filtering = filtering;
        this.pageNumber = pageNumber;
        this.pageSize = pageSize;
        this.sort = sort;
    }

    public boolean equals(Object obj) {
        boolean filterEqual;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PageRequestImpl)) {
            return false;
        }
        PageRequestImpl that = (PageRequestImpl)obj;
        boolean bl = this.filtering == null ? that.filtering == null : (filterEqual = this.filtering.equals(that.filtering));
        boolean sortEqual = this.sort == null ? that.sort == null : this.sort.equals(that.sort);
        boolean othersEqual = this.pageNumber == that.pageNumber && this.pageSize == that.pageSize;
        return filterEqual && othersEqual && sortEqual;
    }

    @Override
    public PageRequest first() {
        return new PageRequestImpl(0, this.getPageSize(), this.getSorting(), this.getFiltering());
    }

    @Override
    public Filtering getFiltering() {
        return this.filtering;
    }

    @Override
    public int getOffset() {
        return this.pageNumber * this.pageSize;
    }

    @Override
    public int getPageNumber() {
        return this.pageNumber;
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public Sorting getSorting() {
        return this.sort;
    }

    @Override
    public boolean hasPrevious() {
        return this.pageNumber > 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.pageNumber;
        result = 31 * result + this.pageSize;
        return 31 * result + (null == this.sort ? 0 : this.sort.hashCode());
    }

    @Override
    public PageRequest next() {
        return new PageRequestImpl(this.getPageNumber() + 1, this.getPageSize(), this.getSorting());
    }

    public PageRequest previous() {
        return this.getPageNumber() == 0 ? this : new PageRequestImpl(this.getPageNumber() - 1, this.getPageSize(), this.getSorting());
    }

    @Override
    public PageRequest previousOrFirst() {
        return this.hasPrevious() ? this.previous() : this.first();
    }

    @Override
    public void setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber;
    }

    @Override
    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    @Override
    public void setSorting(Sorting sort) {
        this.sort = sort;
    }

    @Override
    public void setFiltering(Filtering filtering) {
        this.filtering = filtering;
    }

    public String toString() {
        return String.format("Page request [number: %d, size %d, sort: %s, filtering: %s]", this.getPageNumber(), this.getPageSize(), this.sort == null ? null : this.sort.toString(), this.filtering == null ? null : this.filtering.toString());
    }
}

