/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.impl.identifiable.resource;

import de.digitalcollections.model.api.identifiable.IdentifiableType;
import de.digitalcollections.model.api.identifiable.resource.FileResource;
import de.digitalcollections.model.api.identifiable.resource.MimeType;
import de.digitalcollections.model.api.identifiable.resource.enums.FileResourceType;
import de.digitalcollections.model.api.legal.License;
import de.digitalcollections.model.impl.identifiable.IdentifiableImpl;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.Objects;

public class FileResourceImpl
extends IdentifiableImpl
implements FileResource {
    private String filename;
    protected FileResourceType fileResourceType;
    private License license;
    private MimeType mimeType;
    private boolean readonly = false;
    private long sizeInBytes;
    private URI uri;

    public FileResourceImpl() {
        this.type = IdentifiableType.RESOURCE;
        this.fileResourceType = FileResourceType.UNDEFINED;
    }

    @Override
    public FileResourceType getFileResourceType() {
        return this.fileResourceType;
    }

    @Override
    public void setFileResourceType(FileResourceType fileResourceType) {
        this.fileResourceType = fileResourceType;
    }

    @Override
    public String getFilename() {
        if (this.filename == null && this.uri != null) {
            try {
                this.filename = this.uri.toURL().getFile();
            }
            catch (MalformedURLException ex) {
                this.filename = null;
            }
        }
        return this.filename;
    }

    @Override
    public void setFilename(String filename) {
        this.filename = filename;
    }

    @Override
    public String getFilenameExtension() {
        if (this.filename == null) {
            return null;
        }
        int lastDotPosition = this.filename.lastIndexOf(".");
        if (lastDotPosition >= 0 && lastDotPosition < this.filename.length()) {
            String result = this.filename.substring(lastDotPosition + 1);
            if (result.trim().length() == 0) {
                return null;
            }
            return result;
        }
        return null;
    }

    @Override
    public License getLicense() {
        return this.license;
    }

    @Override
    public void setLicense(License license) {
        this.license = license;
    }

    @Override
    public long getSizeInBytes() {
        return this.sizeInBytes;
    }

    @Override
    public void setSizeInBytes(long sizeInBytes) {
        this.sizeInBytes = sizeInBytes;
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    public void setUri(URI uri) {
        this.uri = uri;
    }

    @Override
    public boolean isReadonly() {
        return this.readonly;
    }

    @Override
    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
    }

    @Override
    public MimeType getMimeType() {
        return this.mimeType;
    }

    @Override
    public void setMimeType(MimeType mimeType) {
        this.mimeType = mimeType;
    }

    public String toString() {
        String mimetypeStr = this.getMimeType() == null ? null : this.getMimeType().getTypeName();
        return this.getClass().getSimpleName() + ":\n{\n  uuid=" + String.valueOf(this.getUuid()) + ",\n  uri=" + String.valueOf(this.uri) + ",\n  mimetype=" + mimetypeStr + ",\n  lastModified=" + this.lastModified + "\n}";
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.filename, this.fileResourceType, this.mimeType, this.sizeInBytes, this.uri});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof FileResourceImpl) {
            FileResourceImpl other = (FileResourceImpl)obj;
            return Objects.equals(this.filename, other.filename) && Objects.equals((Object)this.fileResourceType, (Object)other.fileResourceType) && Objects.equals(this.mimeType, other.mimeType) && Objects.equals(this.sizeInBytes, other.sizeInBytes) && Objects.equals(this.uri, other.uri);
        }
        return false;
    }
}

