/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.api.filter;

import de.digitalcollections.model.api.filter.enums.FilterOperation;
import java.util.Collection;

public class FilterCriterion<T> {
    private FilterOperation operation;
    private String fieldName;
    private Object value;
    private Comparable<?> minValue;
    private Comparable<?> maxValue;
    private Collection<?> values;

    public FilterCriterion(String fieldName, FilterOperation operation, Object value, Comparable<?> minValue, Comparable<?> maxValue, Collection<?> values) {
        this.operation = operation;
        this.fieldName = fieldName;
        this.value = value;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.values = values;
        this.validate();
        if (minValue != null && maxValue != null && minValue.compareTo(maxValue) > 0) {
            this.minValue = maxValue;
            this.maxValue = minValue;
        }
    }

    public FilterCriterion(String fieldName, FilterOperation operation, Object value) {
        this(fieldName, operation, value, null, null, null);
        if (operation == FilterOperation.BETWEEN || operation == FilterOperation.IN || operation == FilterOperation.NOT_IN) {
            throw new IllegalArgumentException("this constructor only supports single value operations");
        }
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
        this.validate();
    }

    public Object getValue() {
        return this.value;
    }

    public Comparable<?> getMinValue() {
        return this.minValue;
    }

    public Comparable<?> getMaxValue() {
        return this.maxValue;
    }

    public FilterOperation getOperation() {
        return this.operation;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Collection<?> getValues() {
        return this.values;
    }

    private void validate() {
        if (this.operation == null) {
            throw new IllegalArgumentException("a filter criterion needs an operation");
        }
        FilterOperation.OperandCount operandCount = this.operation.getOperandCount();
        switch (operandCount) {
            case NO_VALUE: {
                if (this.value == null && this.minValue == null && this.maxValue == null && (this.values == null || this.values.isEmpty())) break;
                throw new IllegalArgumentException("operation does not support operand values!");
            }
            case SINGLEVALUE: {
                if (this.value != null && this.minValue == null && this.maxValue == null && (this.values == null || this.values.isEmpty())) break;
                throw new IllegalArgumentException("operation requires exactly one operand value!");
            }
            case MIN_MAX_VALUES: {
                if (this.value == null && this.minValue != null && this.maxValue != null && (this.values == null || this.values.isEmpty())) break;
                throw new IllegalArgumentException("operation requires exactly one min and one max value!");
            }
            case MULTIVALUE: {
                if (this.value == null && this.minValue == null && this.maxValue == null && this.values != null && !this.values.isEmpty()) break;
                throw new IllegalArgumentException("operation requires a list of values!");
            }
        }
    }
}

