/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.impl.paging;

import de.digitalcollections.model.api.paging.Order;
import de.digitalcollections.model.api.paging.Sorting;
import de.digitalcollections.model.api.paging.enums.Direction;
import de.digitalcollections.model.impl.paging.OrderImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class SortingImpl
implements Sorting {
    private List<Order> orders;

    public SortingImpl() {
    }

    public List<Order> getOrders() {
        return this.orders;
    }

    public void setOrders(List<Order> orders) {
        this.orders = orders;
    }

    public SortingImpl(Order ... orders) {
        this(Arrays.asList(orders));
    }

    public SortingImpl(List<Order> orders) {
        if (null == orders || orders.isEmpty()) {
            throw new IllegalArgumentException("You have to provide at least one sort property to sort by!");
        }
        this.orders = orders;
    }

    public SortingImpl(String ... properties) {
        this(DEFAULT_DIRECTION, properties);
    }

    public SortingImpl(Direction direction, String ... properties) {
        this(direction, properties == null ? new ArrayList() : Arrays.asList(properties));
    }

    public SortingImpl(Direction direction, List<String> properties) {
        if (properties == null || properties.isEmpty()) {
            throw new IllegalArgumentException("You have to provide at least one property to sort by!");
        }
        this.orders = new ArrayList<Order>(properties.size());
        for (String property : properties) {
            this.orders.add(new OrderImpl(direction, property));
        }
    }

    @Override
    public Sorting and(Sorting sort) {
        if (sort == null) {
            return this;
        }
        ArrayList<Order> these = new ArrayList<Order>(this.orders);
        for (Order order : sort) {
            these.add(order);
        }
        return new SortingImpl(these);
    }

    private String collectionToCommaDelimitedString(List<Order> coll) {
        if (coll == null || coll.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Iterator<Order> it = coll.iterator();
        while (it.hasNext()) {
            sb.append("").append(it.next()).append("");
            if (!it.hasNext()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SortingImpl)) {
            return false;
        }
        SortingImpl that = (SortingImpl)obj;
        return this.orders.equals(that.orders);
    }

    @Override
    public Order getOrderFor(String property) {
        for (Order order : this) {
            if (!order.getProperty().equals(property)) continue;
            return order;
        }
        return null;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.orders.hashCode();
        return result;
    }

    @Override
    public Iterator<Order> iterator() {
        return this.orders.iterator();
    }

    public String toString() {
        return this.collectionToCommaDelimitedString(this.orders);
    }
}

