/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.api.paging;

import de.digitalcollections.model.api.paging.Sorting;
import de.digitalcollections.model.impl.paging.PageRequestImpl;

public interface PageRequest {
    public int getPageNumber();

    public int getPageSize();

    public int getOffset();

    public Sorting getSorting();

    public PageRequest next();

    public PageRequest previousOrFirst();

    public PageRequest first();

    public boolean hasPrevious();

    public void setPageSize(int var1);

    public void setSorting(Sorting var1);

    public static Builder defaultBuilder() {
        return new Builder();
    }

    public static class Builder {
        private int pageNumber;
        private int pageSize;
        private Sorting sorting;

        public Builder pageNumber(int pageNumber) {
            this.pageNumber = pageNumber;
            return this;
        }

        public Builder pageSize(int pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Builder sorting(Sorting sorting) {
            this.sorting = sorting;
            return this;
        }

        public PageRequest build() {
            return new PageRequestImpl(this.pageNumber, this.pageSize, this.sorting);
        }
    }
}

