/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.text.contentblock;

import de.digitalcollections.model.text.contentblock.ContentBlockNode;
import de.digitalcollections.model.text.contentblock.HardBreak;
import de.digitalcollections.model.text.contentblock.Heading;
import de.digitalcollections.model.text.contentblock.Mark;
import de.digitalcollections.model.text.contentblock.Text;

public class Paragraph
extends ContentBlockNode {
    public static Builder builder() {
        return new Builder();
    }

    public Paragraph() {
    }

    public Paragraph(String text) {
        this.addContentBlock(new Text(text));
    }

    public static class Builder {
        Paragraph paragraph = new Paragraph();

        public Builder addHardBreak() {
            this.paragraph.addContentBlock(new HardBreak());
            return this;
        }

        public Builder addHeading(int level, String text, String ... marks) {
            this.paragraph.addContentBlock(new Heading(level, text));
            return this;
        }

        public Builder addLink(String text, String href) {
            Text linkText = new Text(text);
            Mark mark = new Mark("link");
            mark.addAttribute("href", href);
            linkText.addMark(mark);
            this.paragraph.addContentBlock(linkText);
            return this;
        }

        public Builder addLinkWithTitle(String text, String href, String title) {
            Text linkText = new Text(text);
            Mark mark = new Mark("link");
            mark.addAttribute("href", href);
            mark.addAttribute("title", title);
            linkText.addMark(mark);
            this.paragraph.addContentBlock(linkText);
            return this;
        }

        public Builder addText(String text) {
            this.paragraph.addContentBlock(new Text(text));
            return this;
        }

        public Builder addText(String text, String ... marks) {
            this.paragraph.addContentBlock(new Text(text, marks));
            return this;
        }

        public Paragraph build() {
            return this.paragraph;
        }
    }
}

