/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.text;

import de.digitalcollections.model.text.LocalizedText;
import de.digitalcollections.model.text.TitleType;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class Title
implements Comparable<Title> {
    private LocalizedText text;
    private Set<Locale> textLocalesOfOriginalScripts;
    private TitleType titleType;

    public Title() {
        this.init();
    }

    public Title(LocalizedText text, Set<Locale> textLocalesOfOriginalScripts, TitleType titleType) {
        this();
        this.text = text;
        if (textLocalesOfOriginalScripts != null) {
            this.textLocalesOfOriginalScripts = textLocalesOfOriginalScripts;
        }
        this.titleType = titleType;
    }

    protected void init() {
        if (this.textLocalesOfOriginalScripts == null) {
            this.textLocalesOfOriginalScripts = new HashSet<Locale>(0);
        }
    }

    public void addTextLocaleOfOriginalScript(Locale locale) {
        this.textLocalesOfOriginalScripts.add(locale);
    }

    public LocalizedText getText() {
        return this.text;
    }

    public Set<Locale> getTextLocalesOfOriginalScripts() {
        return this.textLocalesOfOriginalScripts;
    }

    public TitleType getTitleType() {
        return this.titleType;
    }

    public void setText(LocalizedText text) {
        this.text = text;
    }

    public void setTextLocalesOfOriginalScripts(Set<Locale> localesOfOriginalScripts) {
        this.textLocalesOfOriginalScripts = localesOfOriginalScripts;
    }

    public void setTitleType(TitleType titleType) {
        this.titleType = titleType;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Title)) {
            return false;
        }
        Title title = (Title)o;
        return this == title || Objects.equals(this.text, title.text) && Objects.equals(this.textLocalesOfOriginalScripts, title.textLocalesOfOriginalScripts) && Objects.equals(this.titleType, title.titleType);
    }

    public int hashCode() {
        return Objects.hash(this.text, this.textLocalesOfOriginalScripts, this.titleType);
    }

    @Override
    public int compareTo(Title title) {
        return 1000 * StringUtils.compare((String)(this.titleType != null ? this.titleType.getMainType() : null), title.getTitleType() != null ? title.getTitleType().getMainType() : null) + StringUtils.compare((String)(this.titleType != null ? this.titleType.getSubType() : null), title.getTitleType() != null ? title.getTitleType().getSubType() : null);
    }

    public String toString() {
        return "Title{text=" + this.text + ", textLocalesOfOriginalScripts=" + this.textLocalesOfOriginalScripts + ", titleType=" + this.titleType + "}";
    }

    protected Title(TitleBuilder<?, ?> b) {
        this.text = b.text;
        this.textLocalesOfOriginalScripts = b.textLocalesOfOriginalScripts;
        this.titleType = b.titleType;
    }

    public static TitleBuilder<?, ?> builder() {
        return new TitleBuilderImpl();
    }

    public static abstract class TitleBuilder<C extends Title, B extends TitleBuilder<C, B>> {
        private LocalizedText text;
        private Set<Locale> textLocalesOfOriginalScripts;
        private TitleType titleType;

        public C build() {
            C c = this.prebuild();
            ((Title)c).init();
            return c;
        }

        public B textLocaleOfOriginalScript(Locale locale) {
            if (locale == null) {
                return this.self();
            }
            if (this.textLocalesOfOriginalScripts == null) {
                this.textLocalesOfOriginalScripts = new HashSet<Locale>(1);
            }
            this.textLocalesOfOriginalScripts.add(locale);
            return this.self();
        }

        public B text(LocalizedText text) {
            this.text = text;
            return this.self();
        }

        public B textLocalesOfOriginalScripts(Set<Locale> textLocalesOfOriginalScripts) {
            this.textLocalesOfOriginalScripts = textLocalesOfOriginalScripts;
            return this.self();
        }

        public B titleType(TitleType titleType) {
            this.titleType = titleType;
            return this.self();
        }

        protected abstract B self();

        public abstract C prebuild();

        public String toString() {
            return "Title.TitleBuilder(text=" + this.text + ", textLocalesOfOriginalScripts=" + this.textLocalesOfOriginalScripts + ", titleType=" + this.titleType + ")";
        }
    }

    private static final class TitleBuilderImpl
    extends TitleBuilder<Title, TitleBuilderImpl> {
        private TitleBuilderImpl() {
        }

        @Override
        protected TitleBuilderImpl self() {
            return this;
        }

        @Override
        public Title prebuild() {
            return new Title(this);
        }
    }
}

