/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.text;

import de.digitalcollections.model.text.contentblock.ContentBlock;
import de.digitalcollections.model.text.contentblock.Heading;
import de.digitalcollections.model.text.contentblock.Text;
import de.digitalcollections.model.view.ToCEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class StructuredContent {
    private List<ContentBlock> contentBlocks;

    public void addContentBlock(ContentBlock contentBlock) {
        if (this.getContentBlocks() == null) {
            this.setContentBlocks(new ArrayList<ContentBlock>());
        }
        this.getContentBlocks().add(contentBlock);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StructuredContent)) {
            return false;
        }
        StructuredContent that = (StructuredContent)o;
        return Objects.equals(this.contentBlocks, that.contentBlocks);
    }

    public List<ContentBlock> getContentBlocks() {
        return this.contentBlocks;
    }

    public List<ToCEntry> getTableOfContents() {
        if (this.contentBlocks == null || this.contentBlocks.isEmpty()) {
            return null;
        }
        ArrayList<ToCEntry> toc = new ArrayList<ToCEntry>(0);
        ToCEntry previousEntry = null;
        int previousLevel = 1;
        int index = -1;
        for (ContentBlock contentBlock : this.contentBlocks) {
            ++index;
            if (!(contentBlock instanceof Heading)) continue;
            Heading heading = (Heading)contentBlock;
            int currentLevel = (Integer)heading.getAttribute("level");
            ToCEntry parentEntry = previousEntry;
            ToCEntry currentEntry = new ToCEntry();
            if (currentLevel == 1) {
                toc.add(currentEntry);
            } else {
                if (currentLevel == previousLevel) {
                    parentEntry = previousEntry.getParent();
                } else if (currentLevel == previousLevel + 1) {
                    parentEntry = previousEntry;
                } else if (currentLevel > previousLevel + 1) {
                    for (int i = previousLevel; i < currentLevel - 1; ++i) {
                        ToCEntry newParentNode = new ToCEntry();
                        newParentNode.setParent(previousEntry);
                        previousEntry.addChild(newParentNode);
                        previousEntry = newParentNode;
                    }
                    parentEntry = previousEntry;
                } else if (currentLevel < previousLevel) {
                    parentEntry = previousEntry.getParent();
                    for (int i = previousLevel; i > currentLevel; --i) {
                        parentEntry = parentEntry.getParent();
                    }
                }
                currentEntry.setParent(parentEntry);
                parentEntry.addChild(currentEntry);
            }
            Text text = heading.getContentBlocks().stream().filter(cb -> cb.getClass() == Text.class).findFirst().orElse(null);
            if (text != null) {
                currentEntry.setLabel(text.getText());
            }
            currentEntry.setTargetId(String.valueOf(index));
            previousEntry = currentEntry;
            previousLevel = currentLevel;
        }
        if (toc.isEmpty()) {
            return null;
        }
        return toc;
    }

    public int hashCode() {
        return Objects.hash(this.contentBlocks) + Objects.hash("StructuredContent");
    }

    public void setContentBlocks(List<ContentBlock> contentBlocks) {
        this.contentBlocks = contentBlocks;
    }

    public String toString() {
        return "StructuredContent{contentBlocks=" + this.contentBlocks + "}";
    }
}

