/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.text;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

public class LocalizedText
extends HashMap<Locale, String> {
    public LocalizedText() {
    }

    public LocalizedText(Locale locale, String text) {
        this();
        this.put(locale, text);
    }

    public List<Locale> getLocales() {
        return new ArrayList<Locale>(this.keySet());
    }

    public String getText() {
        List<Locale> locales = this.getLocales();
        if (locales.isEmpty()) {
            return null;
        }
        return this.getText(locales.iterator().next());
    }

    public String getText(Locale locale) {
        if (this.containsKey(locale)) {
            return (String)this.get(locale);
        }
        return this.getText();
    }

    public boolean has(Locale locale) {
        return this.getLocales().contains(locale);
    }

    public void setText(Locale locale, String text) {
        this.put(locale, text);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String toString() {
        return "LocalizedText{" + (this.isEmpty() ? "" : this.entrySet().stream().map(e -> (e.getKey() != null ? ((Locale)e.getKey()).toLanguageTag() : "") + "=" + (String)e.getValue()).collect(Collectors.joining(","))) + "}";
    }

    public static class Builder {
        LocalizedText localizedText = new LocalizedText();

        public Builder text(Locale locale, String text) {
            this.localizedText.put(locale, text);
            return this;
        }

        public Builder text(Map<Locale, String> texts) {
            if (texts != null) {
                this.localizedText.putAll(texts);
            }
            return this;
        }

        public LocalizedText build() {
            return this.localizedText;
        }
    }
}

