/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.security;

import de.digitalcollections.model.UniqueObject;
import de.digitalcollections.model.security.Role;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.Email;
import javax.validation.constraints.NotBlank;
import org.springframework.util.ObjectUtils;

public class User
extends UniqueObject {
    @NotBlank
    @Email
    private String email;
    private boolean enabled;
    @NotBlank
    private String firstname;
    @NotBlank
    private String lastname;
    private String passwordHash;
    private List<Role> roles;

    public User() {
    }

    public String getEmail() {
        return this.email;
    }

    public String getFirstname() {
        return this.firstname;
    }

    public String getLastname() {
        return this.lastname;
    }

    public String getPasswordHash() {
        return this.passwordHash;
    }

    public List<Role> getRoles() {
        return this.roles;
    }

    @Override
    protected void init() {
        super.init();
        this.enabled = true;
        this.roles = new ArrayList<Role>(0);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setFirstname(String firstname) {
        this.firstname = firstname;
    }

    public void setLastname(String lastname) {
        this.lastname = lastname;
    }

    public void setPasswordHash(String passwordHash) {
        if (!ObjectUtils.isEmpty((Object)passwordHash)) {
            this.passwordHash = passwordHash;
        }
    }

    public void setRoles(List<Role> userRoles) {
        this.roles = userRoles;
    }

    protected User(UserBuilder<?, ?> b) {
        super(b);
        this.email = b.email;
        this.enabled = b.enabled;
        this.firstname = b.firstname;
        this.lastname = b.lastname;
        this.passwordHash = b.passwordHash;
        this.roles = b.roles;
    }

    public static UserBuilder<?, ?> builder() {
        return new UserBuilderImpl();
    }

    public static abstract class UserBuilder<C extends User, B extends UserBuilder<C, B>>
    extends UniqueObject.UniqueObjectBuilder<C, B> {
        private String email;
        private boolean enabled;
        private String firstname;
        private String lastname;
        private String passwordHash;
        private List<Role> roles;

        public B email(String email) {
            this.email = email;
            return (B)this.self();
        }

        public B enabled(boolean enabled) {
            this.enabled = enabled;
            return (B)this.self();
        }

        public B firstname(String firstname) {
            this.firstname = firstname;
            return (B)this.self();
        }

        public B lastname(String lastname) {
            this.lastname = lastname;
            return (B)this.self();
        }

        public B passwordHash(String passwordHash) {
            this.passwordHash = passwordHash;
            return (B)this.self();
        }

        public B roles(List<Role> roles) {
            this.roles = roles;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C prebuild();

        @Override
        public String toString() {
            return "User.UserBuilder(super=" + super.toString() + ", email=" + this.email + ", enabled=" + this.enabled + ", firstname=" + this.firstname + ", lastname=" + this.lastname + ", passwordHash=" + this.passwordHash + ", roles=" + this.roles + ")";
        }
    }

    private static final class UserBuilderImpl
    extends UserBuilder<User, UserBuilderImpl> {
        private UserBuilderImpl() {
        }

        @Override
        protected UserBuilderImpl self() {
            return this;
        }

        @Override
        public User prebuild() {
            return new User(this);
        }
    }
}

