/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.list.sorting;

import de.digitalcollections.model.list.sorting.Direction;
import de.digitalcollections.model.list.sorting.NullHandling;
import de.digitalcollections.model.list.sorting.Sorting;
import java.util.Optional;

public class Order {
    private static final Direction DEFAULT_DIRECTION = Sorting.DEFAULT_DIRECTION;
    private static final boolean DEFAULT_IGNORE_CASE = true;
    private static final NullHandling DEFAULT_NULL_HANDLING = NullHandling.NATIVE;
    private Direction direction;
    private Boolean ignoreCase;
    private NullHandling nullHandling;
    private String property;
    private String subProperty;

    public Order() {
        this.init();
    }

    public Order(Direction direction, boolean ignoreCase, NullHandling nullHandling, String property) {
        this(direction, property, ignoreCase, nullHandling);
    }

    public Order(Direction direction, String property) {
        this(direction, property, true, null);
    }

    public Order(Direction direction, String property, NullHandling nullHandlingHint) {
        this(direction, property, true, nullHandlingHint);
    }

    public Order(String property) {
        this(null, property);
    }

    private Order(Direction direction, String property, boolean ignoreCase, NullHandling nullHandling) {
        this.init();
        if (direction != null) {
            this.direction = direction;
        }
        this.ignoreCase = ignoreCase;
        if (nullHandling != null) {
            this.nullHandling = nullHandling;
        }
        this.property = property;
        if (property == null || property.isEmpty() || property.trim().isEmpty()) {
            throw new IllegalArgumentException("Property must not null or empty!");
        }
        this.property = property;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Order)) {
            return false;
        }
        Order that = (Order)obj;
        return this.direction.equals((Object)that.getDirection()) && this.property.equals(that.getProperty()) && this.ignoreCase.booleanValue() == that.isIgnoreCase() && this.nullHandling.equals((Object)that.getNullHandling());
    }

    public Direction getDirection() {
        return this.direction;
    }

    public NullHandling getNullHandling() {
        return this.nullHandling;
    }

    public String getProperty() {
        return this.property;
    }

    public Optional<String> getSubProperty() {
        return Optional.ofNullable(this.subProperty);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.direction.hashCode();
        result = 31 * result + this.property.hashCode();
        result = 31 * result + (this.ignoreCase != false ? 1 : 0);
        result = 31 * result + this.nullHandling.hashCode();
        return result;
    }

    protected void init() {
        if (this.direction == null) {
            this.direction = DEFAULT_DIRECTION;
        }
        if (this.ignoreCase == null) {
            this.ignoreCase = true;
        }
        if (this.nullHandling == null) {
            this.nullHandling = DEFAULT_NULL_HANDLING;
        }
    }

    public boolean isAscending() {
        return this.direction.isAscending();
    }

    public boolean isDescending() {
        return this.direction.isDescending();
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    public void setNullHandling(NullHandling nullHandling) {
        this.nullHandling = nullHandling;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public void setSubProperty(String property) {
        this.subProperty = property;
    }

    public String toString() {
        Object result = String.format("%s: %s", new Object[]{this.property, this.direction});
        if (!NullHandling.NATIVE.equals((Object)this.nullHandling)) {
            result = (String)result + ", " + this.nullHandling;
        }
        if (this.ignoreCase.booleanValue()) {
            result = (String)result + ", ignoring case";
        }
        return result;
    }

    protected Order(OrderBuilder<?, ?> b) {
        this.direction = b.direction;
        this.ignoreCase = b.ignoreCase;
        this.nullHandling = b.nullHandling;
        this.property = b.property;
        this.subProperty = b.subProperty;
    }

    public static OrderBuilder<?, ?> builder() {
        return new OrderBuilderImpl();
    }

    public static abstract class OrderBuilder<C extends Order, B extends OrderBuilder<C, B>> {
        private Direction direction;
        private Boolean ignoreCase;
        private NullHandling nullHandling;
        private String property;
        private String subProperty;

        public C build() {
            C c = this.prebuild();
            ((Order)c).init();
            return c;
        }

        public B direction(Direction direction) {
            this.direction = direction;
            return this.self();
        }

        public B ignoreCase(Boolean ignoreCase) {
            this.ignoreCase = ignoreCase;
            return this.self();
        }

        public B nullHandling(NullHandling nullHandling) {
            this.nullHandling = nullHandling;
            return this.self();
        }

        public B property(String property) {
            this.property = property;
            return this.self();
        }

        public B subProperty(String subProperty) {
            this.subProperty = subProperty;
            return this.self();
        }

        protected abstract B self();

        public abstract C prebuild();

        public String toString() {
            return "Order.OrderBuilder(direction=" + this.direction + ", ignoreCase=" + this.ignoreCase + ", nullHandling=" + this.nullHandling + ", property=" + this.property + ", subProperty=" + this.subProperty + ")";
        }
    }

    private static final class OrderBuilderImpl
    extends OrderBuilder<Order, OrderBuilderImpl> {
        private OrderBuilderImpl() {
        }

        @Override
        protected OrderBuilderImpl self() {
            return this;
        }

        @Override
        public Order prebuild() {
            return new Order(this);
        }
    }
}

