/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.list.sorting;

import java.util.Locale;

public enum Direction {
    ASC,
    DESC;


    public boolean isAscending() {
        return this.equals((Object)ASC);
    }

    public boolean isDescending() {
        return this.equals((Object)DESC);
    }

    public static Direction fromString(String value) {
        try {
            return Direction.valueOf(value.toUpperCase(Locale.US));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Invalid value '%s' for orders given! Has to be either 'desc' or 'asc' (case insensitive).", value), e);
        }
    }

    public static Direction fromStringOrNull(String value) {
        try {
            return Direction.fromString(value);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

