/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.list.paging;

import de.digitalcollections.model.list.ListRequest;
import de.digitalcollections.model.list.filtering.Filtering;
import de.digitalcollections.model.list.sorting.Direction;
import de.digitalcollections.model.list.sorting.Order;
import de.digitalcollections.model.list.sorting.Sorting;
import java.util.List;

public class PageRequest
extends ListRequest {
    private int pageNumber;
    private int pageSize;

    public static Builder builder() {
        return new Builder();
    }

    public PageRequest() {
        this.init();
    }

    public PageRequest(int pageNumber, int pageSize) {
        this(pageNumber, pageSize, (Sorting)null, (Filtering)null, (String)null);
    }

    public PageRequest(int pageNumber, int pageSize, Direction direction, String ... properties) {
        this(pageNumber, pageSize, new Sorting(direction, properties), null, null);
    }

    public PageRequest(int pageNumber, int pageSize, Sorting sorting) {
        this(pageNumber, pageSize, sorting, null, null);
    }

    public PageRequest(int pageNumber, int pageSize, Sorting sorting, Filtering filtering) {
        this(pageNumber, pageSize, sorting, filtering, null);
    }

    public PageRequest(String searchTerm, int pageNumber, int pageSize) {
        this(pageNumber, pageSize, (Sorting)null, (Filtering)null, searchTerm);
    }

    public PageRequest(String searchTerm, int pageNumber, int pageSize, Sorting sorting) {
        this(pageNumber, pageSize, sorting, null, searchTerm);
    }

    public PageRequest(int pageNumber, int pageSize, Sorting sorting, Filtering filtering, String searchTerm) {
        super(sorting, filtering, searchTerm);
        this.init();
        if (pageNumber < 0) {
            throw new IllegalArgumentException("Page index must not be less than zero!");
        }
        if (pageSize < 1) {
            throw new IllegalArgumentException("Page size must not be less than one!");
        }
        this.pageNumber = pageNumber;
        this.pageSize = pageSize;
    }

    public PageRequest(int pageNumber, int pageSize, List<Order> sortBy) {
        this(pageNumber, pageSize);
        if (sortBy != null) {
            Sorting sorting = new Sorting(sortBy);
            this.setSorting(sorting);
        }
    }

    @Override
    public boolean equals(Object obj) {
        boolean filterEqual;
        boolean searchTermEqual;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PageRequest)) {
            return false;
        }
        PageRequest that = (PageRequest)obj;
        boolean bl = this.searchTerm == null ? that.searchTerm == null : (searchTermEqual = this.searchTerm.equals(that.searchTerm));
        boolean bl2 = this.filtering == null ? that.filtering == null : (filterEqual = this.filtering.equals(that.filtering));
        boolean sortEqual = this.sorting == null ? that.sorting == null : this.sorting.equals(that.sorting);
        boolean othersEqual = this.pageNumber == that.pageNumber && this.pageSize == that.pageSize;
        return searchTermEqual && filterEqual && othersEqual && sortEqual;
    }

    public PageRequest first() {
        return new PageRequest(0, this.getPageSize(), this.getSorting(), this.getFiltering(), this.getSearchTerm());
    }

    public int getOffset() {
        return this.pageNumber * this.pageSize;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public boolean hasPrevious() {
        return this.pageNumber > 0;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.pageNumber;
        result = 31 * result + this.pageSize;
        return 31 * result + (null == this.sorting ? 0 : this.sorting.hashCode()) + (null == this.filtering ? 0 : this.filtering.hashCode());
    }

    @Override
    protected void init() {
        super.init();
    }

    public PageRequest next() {
        return new PageRequest(this.getPageNumber() + 1, this.getPageSize(), this.getSorting(), this.getFiltering(), this.getSearchTerm());
    }

    public PageRequest previous() {
        return this.getPageNumber() == 0 ? this : new PageRequest(this.getPageNumber() - 1, this.getPageSize(), this.getSorting(), this.getFiltering(), this.getSearchTerm());
    }

    public PageRequest previousOrFirst() {
        return this.hasPrevious() ? this.previous() : this.first();
    }

    public void setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    @Override
    public String toString() {
        return String.format("Page request [number: %d, size %d, sorting: %s, filtering: %s, searchTerm: %s]", this.getPageNumber(), this.getPageSize(), this.sorting == null ? null : this.sorting.toString(), this.filtering == null ? null : this.filtering.toString(), this.searchTerm == null ? null : this.searchTerm);
    }

    public static class Builder {
        private Filtering filtering;
        private int pageNumber;
        private int pageSize;
        private String searchTerm;
        private Sorting sorting;

        public PageRequest build() {
            return new PageRequest(this.pageNumber, this.pageSize, this.sorting, this.filtering, this.searchTerm);
        }

        public Builder filtering(Filtering filtering) {
            this.filtering = filtering;
            return this;
        }

        public Builder pageNumber(int pageNumber) {
            this.pageNumber = pageNumber;
            return this;
        }

        public Builder pageSize(int pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Builder searchTerm(String searchTerm) {
            this.searchTerm = searchTerm;
            return this;
        }

        public Builder sorting(Sorting sorting) {
            this.sorting = sorting;
            return this;
        }
    }
}

