/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.list.filtering;

import de.digitalcollections.model.list.filtering.FilterCriteria;
import de.digitalcollections.model.list.filtering.FilterCriterion;
import de.digitalcollections.model.list.filtering.FilterLogicalOperator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public class Filtering {
    private List<FilterCriteria> filterCriteriaList;

    public Filtering() {
        this.init();
    }

    @Deprecated
    public Filtering(List<FilterCriterion> filterCriteria) {
        this();
        this.filterCriteriaList.add(new FilterCriteria(filterCriteria));
    }

    public List<FilterCriteria> add(Filtering filtering) {
        if (this.getFilterCriteriaList() == null) {
            this.setFilterCriteriaList(new ArrayList<FilterCriteria>());
        }
        if (filtering == null || filtering.getFilterCriteriaList() == null) {
            return this.getFilterCriteriaList();
        }
        filtering.getFilterCriteriaList().stream().forEach(filterCriteria -> this.add(filterCriteria.getCriterionLink(), (List<FilterCriterion>)filterCriteria));
        return this.getFilterCriteriaList();
    }

    public void add(FilterCriterion filterCriterion) {
        this.add(FilterLogicalOperator.AND, List.of(filterCriterion));
    }

    public void add(FilterLogicalOperator criteriaLink, List<FilterCriterion> filterCriterions) {
        if (this.filterCriteriaList.isEmpty()) {
            this.filterCriteriaList.add(new FilterCriteria(criteriaLink, filterCriterions));
            return;
        }
        this.filterCriteriaList.stream().filter(fc -> fc.getCriterionLink() == criteriaLink).findFirst().ifPresentOrElse(fc -> fc.addAll(filterCriterions), () -> this.filterCriteriaList.add(new FilterCriteria(filterCriterions)));
    }

    public void add(String expression, FilterCriterion filterCriterion) {
        if (filterCriterion == null || expression == null) {
            return;
        }
        FilterCriterion filterCriterionWithExpression = new FilterCriterion(filterCriterion);
        filterCriterionWithExpression.setExpression(expression);
        this.add(filterCriterionWithExpression);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Filtering)) {
            return false;
        }
        Filtering filtering = (Filtering)o;
        return Objects.equals(this.filterCriteriaList, filtering.filterCriteriaList);
    }

    public List<FilterCriteria> getFilterCriteriaList() {
        return this.filterCriteriaList;
    }

    public FilterCriteria getFilterCriteriaListFor(String property) {
        return this.filterCriteriaList.stream().filter(f -> f.hasFilterCriterionFor(property)).findFirst().orElse(null);
    }

    public <T> FilterCriterion<T> getFilterCriterionFor(String property) {
        return this.filterCriteriaList.stream().flatMap(fcriteria -> fcriteria.hasFilterCriterionFor(property) ? Stream.of(fcriteria.getFilterCriterionFor(property)) : null).findFirst().orElse(null);
    }

    public int hashCode() {
        return Objects.hash(this.filterCriteriaList) + Objects.hash("Filtering");
    }

    protected void init() {
        if (this.filterCriteriaList == null || this.filterCriteriaList.isEmpty()) {
            this.filterCriteriaList = new ArrayList<FilterCriteria>();
        }
    }

    public boolean isEmpty() {
        return this.filterCriteriaList == null || this.filterCriteriaList.parallelStream().allMatch(ArrayList::isEmpty);
    }

    public Iterator<FilterCriteria> iterator() {
        return this.filterCriteriaList.iterator();
    }

    public void setFilterCriteriaList(List<FilterCriteria> filterCriteria) {
        this.filterCriteriaList = filterCriteria;
    }

    public Stream<FilterCriterion> stream() {
        return this.filterCriteriaList != null && !this.filterCriteriaList.isEmpty() ? this.filterCriteriaList.stream().flatMap(Collection::stream) : Stream.empty();
    }

    public String toString() {
        return "Filtering{filterCriteria=" + this.filterCriteriaList + "}";
    }

    protected Filtering(FilteringBuilder<?, ?> b) {
        List<Object> filterCriteriaList;
        switch (b.filterCriteriaList == null ? 0 : b.filterCriteriaList.size()) {
            case 0: {
                filterCriteriaList = Collections.emptyList();
                break;
            }
            case 1: {
                filterCriteriaList = Collections.singletonList(b.filterCriteriaList.get(0));
                break;
            }
            default: {
                filterCriteriaList = Collections.unmodifiableList(new ArrayList<FilterCriteria>(b.filterCriteriaList));
            }
        }
        this.filterCriteriaList = filterCriteriaList;
    }

    public static FilteringBuilder<?, ?> builder() {
        return new FilteringBuilderImpl();
    }

    public static abstract class FilteringBuilder<C extends Filtering, B extends FilteringBuilder<C, B>> {
        private ArrayList<FilterCriteria> filterCriteriaList;

        public C build() {
            C c = this.prebuild();
            ((Filtering)c).init();
            return c;
        }

        public B filterCriterion(FilterLogicalOperator criteriaLink, FilterCriterion criterion) {
            if (criterion == null) {
                return this.self();
            }
            if (this.filterCriteriaList == null) {
                this.filterCriteriaList = new ArrayList(1);
            }
            this.filterCriteriaList.stream().filter(fc -> fc.getCriterionLink() == criteriaLink).findFirst().ifPresentOrElse(fc -> fc.add(criterion), () -> this.filterCriteriaList.add(new FilterCriteria(criteriaLink, criterion)));
            return this.self();
        }

        public B add(FilterCriterion filterCriterion) {
            return this.filterCriterion(FilterLogicalOperator.AND, filterCriterion);
        }

        public B add(String expression, FilterCriterion filterCriterion) {
            if (filterCriterion != null) {
                filterCriterion.setExpression(expression);
            }
            return this.filterCriterion(FilterLogicalOperator.AND, filterCriterion);
        }

        public B filterCriteria(FilterCriteria filterCriteria) {
            if (this.filterCriteriaList == null) {
                this.filterCriteriaList = new ArrayList();
            }
            this.filterCriteriaList.add(filterCriteria);
            return this.self();
        }

        public B filterCriteriaList(Collection<? extends FilterCriteria> filterCriteriaList) {
            if (filterCriteriaList == null) {
                throw new NullPointerException("filterCriteriaList cannot be null");
            }
            if (this.filterCriteriaList == null) {
                this.filterCriteriaList = new ArrayList();
            }
            this.filterCriteriaList.addAll(filterCriteriaList);
            return this.self();
        }

        public B clearFilterCriteriaList() {
            if (this.filterCriteriaList != null) {
                this.filterCriteriaList.clear();
            }
            return this.self();
        }

        protected abstract B self();

        public abstract C prebuild();

        public String toString() {
            return "Filtering.FilteringBuilder(filterCriteriaList=" + this.filterCriteriaList + ")";
        }
    }

    private static final class FilteringBuilderImpl
    extends FilteringBuilder<Filtering, FilteringBuilderImpl> {
        private FilteringBuilderImpl() {
        }

        @Override
        protected FilteringBuilderImpl self() {
            return this;
        }

        @Override
        public Filtering prebuild() {
            return new Filtering(this);
        }
    }
}

