/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.list.filtering;

import de.digitalcollections.model.list.filtering.FilterCriterion;
import de.digitalcollections.model.list.filtering.FilterLogicalOperator;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public class FilterCriteria
extends ArrayList<FilterCriterion> {
    private FilterLogicalOperator criterionLink = FilterLogicalOperator.AND;

    public FilterCriteria() {
        super(1);
    }

    public FilterCriteria(FilterLogicalOperator criterionLink) {
        this();
        this.criterionLink = criterionLink;
    }

    public FilterCriteria(FilterCriterion ... criterions) {
        this();
        Stream.of(criterions).forEachOrdered(this::add);
    }

    public FilterCriteria(List<FilterCriterion> criterions) {
        this();
        this.addAll(criterions);
    }

    public FilterCriteria(FilterLogicalOperator criterionLink, FilterCriterion ... criterions) {
        this(criterions);
        this.criterionLink = criterionLink;
    }

    public FilterCriteria(FilterLogicalOperator criterionLink, List<FilterCriterion> criterions) {
        this(criterions);
        this.criterionLink = criterionLink;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof FilterCriteria)) {
            return false;
        }
        FilterCriteria other = (FilterCriteria)o;
        return super.equals(o) && this.criterionLink == other.criterionLink;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.criterionLink.hashCode() + "FilterCriteria".hashCode();
    }

    @Override
    public String toString() {
        return "FilterCriteria{criterionLink=" + this.criterionLink + ", content=" + super.toString() + "}";
    }

    public FilterLogicalOperator getCriterionLink() {
        return this.criterionLink;
    }

    public void setCriterionLink(FilterLogicalOperator criterionLink) {
        this.criterionLink = criterionLink;
    }

    public boolean hasFilterCriterionFor(String property) {
        return this.stream().anyMatch(fc -> Objects.equals(fc.getExpression(), property));
    }

    public <T> FilterCriterion<T> getFilterCriterionFor(String property) {
        return this.stream().filter(fc -> Objects.equals(fc.getExpression(), property)).findFirst().orElse(null);
    }
}

