/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.list.buckets;

import de.digitalcollections.model.UniqueObject;
import de.digitalcollections.model.list.ListRequest;
import de.digitalcollections.model.list.buckets.Bucket;
import de.digitalcollections.model.list.filtering.Filtering;
import de.digitalcollections.model.list.sorting.Sorting;

public class BucketsRequest<T extends UniqueObject>
extends ListRequest {
    private static final long serialVersionUID = 1L;
    private int numberOfBuckets;
    private Bucket<T> parentBucket;

    public BucketsRequest(int numberOfBuckets, Bucket<T> parentBucket, Sorting sorting, Filtering filtering) {
        super(sorting, filtering, null);
        if (numberOfBuckets < 1) {
            throw new IllegalArgumentException("numberOfBuckets must not be less than one!");
        }
        this.numberOfBuckets = numberOfBuckets;
        this.parentBucket = parentBucket;
    }

    public BucketsRequest(int numberOfBuckets, T startObject, T endObject, Sorting sorting, Filtering filtering) {
        this(numberOfBuckets, new Bucket<T>(startObject, endObject), sorting, filtering);
    }

    public BucketsRequest(int numberOfBuckets) {
        this(numberOfBuckets, (Bucket)null, (Sorting)null, (Filtering)null);
    }

    public BucketsRequest() {
    }

    public int getNumberOfBuckets() {
        return this.numberOfBuckets;
    }

    public Bucket<T> getParentBucket() {
        return this.parentBucket;
    }

    public void setNumberOfBuckets(int numberOfBuckets) {
        this.numberOfBuckets = numberOfBuckets;
    }

    public void setParentBucket(Bucket<T> parentBucket) {
        this.parentBucket = parentBucket;
    }
}

