/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.identifiable.semantic;

import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.identifiable.IdentifiableType;
import de.digitalcollections.model.identifiable.Identifier;
import de.digitalcollections.model.text.LocalizedText;
import java.util.Objects;
import java.util.Set;

public class Subject
extends Identifiable {
    private String subjectType;

    public Subject() {
    }

    public Subject(LocalizedText label, Set<Identifier> identifiers, String subjectType) {
        this();
        this.label = label;
        this.identifiers = identifiers;
        this.subjectType = subjectType;
    }

    public String getSubjectType() {
        return this.subjectType;
    }

    @Override
    protected void init() {
        super.init();
        this.type = IdentifiableType.RESOURCE;
    }

    public void setSubjectType(String subjectType) {
        this.subjectType = subjectType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Subject)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Subject subject = (Subject)o;
        return Objects.equals(this.subjectType, subject.subjectType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.identifiers, this.label, this.subjectType);
    }

    public String toString() {
        return "Subject{identifiers=" + this.identifiers + ", label=" + this.label + ", subjectType='" + this.subjectType + "', created=" + this.created + ", lastModified=" + this.lastModified + ", uuid=" + this.uuid + "}";
    }

    protected Subject(SubjectBuilder<?, ?> b) {
        super((Identifiable.IdentifiableBuilder<?, ?>)b);
        this.subjectType = b.subjectType;
    }

    public static SubjectBuilder<?, ?> builder() {
        return new SubjectBuilderImpl();
    }

    public static abstract class SubjectBuilder<C extends Subject, B extends SubjectBuilder<C, B>>
    extends Identifiable.IdentifiableBuilder<C, B> {
        private String subjectType;

        @Override
        public C build() {
            Identifiable c = this.prebuild();
            ((Subject)c).init();
            return (C)c;
        }

        public B subjectType(String subjectType) {
            this.subjectType = subjectType;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C prebuild();

        @Override
        public String toString() {
            return "Subject.SubjectBuilder(super=" + super.toString() + ", subjectType=" + this.subjectType + ")";
        }
    }

    private static final class SubjectBuilderImpl
    extends SubjectBuilder<Subject, SubjectBuilderImpl> {
        private SubjectBuilderImpl() {
        }

        @Override
        protected SubjectBuilderImpl self() {
            return this;
        }

        @Override
        public Subject prebuild() {
            return new Subject(this);
        }
    }
}

