/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.identifiable.resource;

import de.digitalcollections.model.file.MimeType;
import de.digitalcollections.model.identifiable.resource.FileResource;
import de.digitalcollections.model.identifiable.resource.FileResourceType;
import java.util.Objects;

public class ImageFileResource
extends FileResource {
    private int height;
    private int width;

    public ImageFileResource() {
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImageFileResource)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageFileResource that = (ImageFileResource)o;
        return this.height == that.height && this.width == that.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.height, this.width);
    }

    @Override
    protected void init() {
        super.init();
        this.fileResourceType = FileResourceType.IMAGE;
        if (this.getMimeType() == null) {
            this.setMimeType(MimeType.MIME_IMAGE);
        }
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    protected ImageFileResource(ImageFileResourceBuilder<?, ?> b) {
        super((FileResource.FileResourceBuilder<?, ?>)b);
        this.height = b.height;
        this.width = b.width;
    }

    public static ImageFileResourceBuilder<?, ?> builder() {
        return new ImageFileResourceBuilderImpl();
    }

    public static abstract class ImageFileResourceBuilder<C extends ImageFileResource, B extends ImageFileResourceBuilder<C, B>>
    extends FileResource.FileResourceBuilder<C, B> {
        private int height;
        private int width;

        @Override
        public C build() {
            FileResource c = this.prebuild();
            ((ImageFileResource)c).init();
            this.setInternalReferences(c);
            return (C)c;
        }

        public B height(int height) {
            this.height = height;
            return (B)this.self();
        }

        public B width(int width) {
            this.width = width;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C prebuild();

        @Override
        public String toString() {
            return "ImageFileResource.ImageFileResourceBuilder(super=" + super.toString() + ", height=" + this.height + ", width=" + this.width + ")";
        }
    }

    private static final class ImageFileResourceBuilderImpl
    extends ImageFileResourceBuilder<ImageFileResource, ImageFileResourceBuilderImpl> {
        private ImageFileResourceBuilderImpl() {
        }

        @Override
        protected ImageFileResourceBuilderImpl self() {
            return this;
        }

        @Override
        public ImageFileResource prebuild() {
            return new ImageFileResource(this);
        }
    }
}

