/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.identifiable.resource;

import de.digitalcollections.model.file.MimeType;
import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.identifiable.IdentifiableType;
import de.digitalcollections.model.identifiable.resource.FileResourceType;
import de.digitalcollections.model.legal.License;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Locale;
import java.util.Objects;

public class FileResource
extends Identifiable {
    protected FileResourceType fileResourceType;
    private String filename;
    private URL httpBaseUrl;
    private License license;
    private MimeType mimeType;
    private boolean readonly;
    private long sizeInBytes;
    private URI uri;

    public FileResource() {
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FileResource)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FileResource that = (FileResource)o;
        return this.readonly == that.readonly && this.sizeInBytes == that.sizeInBytes && this.fileResourceType == that.fileResourceType && Objects.equals(this.filename, that.filename) && Objects.equals(this.httpBaseUrl, that.httpBaseUrl) && Objects.equals(this.license, that.license) && Objects.equals(this.mimeType, that.mimeType) && Objects.equals(this.uri, that.uri);
    }

    public FileResourceType getFileResourceType() {
        return this.fileResourceType;
    }

    public String getFilename() {
        if (this.filename == null && this.uri != null) {
            try {
                this.filename = this.uri.toURL().getFile();
                if (this.filename.contains("/")) {
                    this.filename = this.filename.substring(this.filename.lastIndexOf(47) + 1);
                }
                if (this.filename.contains("?")) {
                    this.filename = this.filename.substring(0, this.filename.indexOf(63));
                }
            }
            catch (MalformedURLException ex) {
                this.filename = null;
            }
        }
        return this.filename;
    }

    public String getFilenameExtension() {
        String filename = this.getFilename();
        if (filename == null) {
            return null;
        }
        int lastDotPosition = filename.lastIndexOf(".");
        if (lastDotPosition >= 0 && lastDotPosition < filename.length()) {
            String result = filename.substring(lastDotPosition + 1);
            if (result.trim().length() == 0) {
                return null;
            }
            return result;
        }
        return null;
    }

    public URL getHttpBaseUrl() {
        return this.httpBaseUrl;
    }

    public License getLicense() {
        return this.license;
    }

    public MimeType getMimeType() {
        return this.mimeType;
    }

    public long getSizeInBytes() {
        return this.sizeInBytes;
    }

    public URI getUri() {
        return this.uri;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.fileResourceType, this.filename, this.httpBaseUrl, this.license, this.mimeType, this.readonly, this.sizeInBytes, this.uri});
    }

    @Override
    protected void init() {
        super.init();
        this.type = IdentifiableType.RESOURCE;
        this.fileResourceType = FileResourceType.UNDEFINED;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setFileResourceType(FileResourceType fileResourceType) {
        this.fileResourceType = fileResourceType;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setHttpBaseUrl(URL httpBaseUrl) {
        this.httpBaseUrl = httpBaseUrl;
    }

    public void setLicense(License license) {
        this.license = license;
    }

    public void setMimeType(MimeType mimeType) {
        this.mimeType = mimeType;
    }

    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
    }

    public void setSizeInBytes(long sizeInBytes) {
        this.sizeInBytes = sizeInBytes;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public String toString() {
        String mimetypeStr = this.getMimeType() == null ? null : this.getMimeType().getTypeName();
        return this.getClass().getSimpleName() + "{created=" + this.created + ", lastModified=" + this.lastModified + ", uuid=" + String.valueOf(this.getUuid()) + ", description=" + this.description + ", identifiers=" + this.identifiers + ", label=" + this.label + ", localizedUrlAliases=" + this.localizedUrlAliases + ", previewImage=" + this.previewImage + ", previewImageRenderingHints=" + this.previewImageRenderingHints + ", type=" + this.type + ", fileResourceType=" + this.fileResourceType + ", filename='" + this.filename + "', httpBaseUrl=" + this.httpBaseUrl + ", license=" + this.license + ", mimeType=" + mimetypeStr + ", readonly=" + this.readonly + ", sizeInBytes=" + this.sizeInBytes + ", uri=" + String.valueOf(this.uri) + "}";
    }

    protected FileResource(FileResourceBuilder<?, ?> b) {
        super((Identifiable.IdentifiableBuilder<?, ?>)b);
        this.fileResourceType = b.fileResourceType;
        this.filename = b.filename;
        this.httpBaseUrl = b.httpBaseUrl;
        this.license = b.license;
        this.mimeType = b.mimeType;
        this.readonly = b.readonly;
        this.sizeInBytes = b.sizeInBytes;
        this.uri = b.uri;
    }

    public static FileResourceBuilder<?, ?> builder() {
        return new FileResourceBuilderImpl();
    }

    public static abstract class FileResourceBuilder<C extends FileResource, B extends FileResourceBuilder<C, B>>
    extends Identifiable.IdentifiableBuilder<C, B> {
        private FileResourceType fileResourceType;
        private String filename;
        private URL httpBaseUrl;
        private License license;
        private MimeType mimeType;
        private boolean readonly;
        private long sizeInBytes;
        private URI uri;

        @Override
        public C build() {
            Identifiable c = this.prebuild();
            ((FileResource)c).init();
            this.setInternalReferences(c);
            return (C)c;
        }

        public B httpBaseUrl(URL httpBaseUrl) {
            this.httpBaseUrl = httpBaseUrl;
            return (B)this.self();
        }

        public B httpBaseUrl(String httpBaseUrl) {
            try {
                return this.httpBaseUrl(new URL(httpBaseUrl));
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }

        public B licenseOfName(String licenseName) {
            this.license = ((License.LicenseBuilder)((License.LicenseBuilder)((License.LicenseBuilder)License.builder().label(Locale.GERMAN, licenseName)).acronym(licenseName)).url("https://localhost/licence/" + licenseName)).build();
            return (B)this.self();
        }

        public B readwrite() {
            this.readonly = false;
            return (B)this.self();
        }

        public B type(FileResourceType fileResourceType) {
            this.fileResourceType = fileResourceType;
            return (B)this.self();
        }

        public B uri(URI uri) {
            this.uri = uri;
            return (B)this.self();
        }

        public B uri(String uri) {
            return this.uri(URI.create(uri));
        }

        public B fileResourceType(FileResourceType fileResourceType) {
            this.fileResourceType = fileResourceType;
            return (B)this.self();
        }

        public B filename(String filename) {
            this.filename = filename;
            return (B)this.self();
        }

        public B license(License license) {
            this.license = license;
            return (B)this.self();
        }

        public B mimeType(MimeType mimeType) {
            this.mimeType = mimeType;
            return (B)this.self();
        }

        public B readonly(boolean readonly) {
            this.readonly = readonly;
            return (B)this.self();
        }

        public B sizeInBytes(long sizeInBytes) {
            this.sizeInBytes = sizeInBytes;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C prebuild();

        @Override
        public String toString() {
            return "FileResource.FileResourceBuilder(super=" + super.toString() + ", fileResourceType=" + this.fileResourceType + ", filename=" + this.filename + ", httpBaseUrl=" + this.httpBaseUrl + ", license=" + this.license + ", mimeType=" + this.mimeType + ", readonly=" + this.readonly + ", sizeInBytes=" + this.sizeInBytes + ", uri=" + this.uri + ")";
        }
    }

    private static final class FileResourceBuilderImpl
    extends FileResourceBuilder<FileResource, FileResourceBuilderImpl> {
        private FileResourceBuilderImpl() {
        }

        @Override
        protected FileResourceBuilderImpl self() {
            return this;
        }

        @Override
        public FileResource prebuild() {
            return new FileResource(this);
        }
    }
}

