/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.identifiable.resource;

import de.digitalcollections.model.file.MimeType;
import de.digitalcollections.model.identifiable.resource.FileResource;
import de.digitalcollections.model.identifiable.resource.FileResourceType;

public class AudioFileResource
extends FileResource {
    private int duration;

    public AudioFileResource() {
    }

    public int getDuration() {
        return this.duration;
    }

    @Override
    protected void init() {
        super.init();
        this.fileResourceType = FileResourceType.AUDIO;
        if (this.getMimeType() == null) {
            this.setMimeType(MimeType.MIME_AUDIO);
        }
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    protected AudioFileResource(AudioFileResourceBuilder<?, ?> b) {
        super((FileResource.FileResourceBuilder<?, ?>)b);
        this.duration = b.duration;
    }

    public static AudioFileResourceBuilder<?, ?> builder() {
        return new AudioFileResourceBuilderImpl();
    }

    public static abstract class AudioFileResourceBuilder<C extends AudioFileResource, B extends AudioFileResourceBuilder<C, B>>
    extends FileResource.FileResourceBuilder<C, B> {
        private int duration;

        @Override
        public C build() {
            FileResource c = this.prebuild();
            ((AudioFileResource)c).init();
            this.setInternalReferences(c);
            return (C)c;
        }

        public B duration(int duration) {
            this.duration = duration;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C prebuild();

        @Override
        public String toString() {
            return "AudioFileResource.AudioFileResourceBuilder(super=" + super.toString() + ", duration=" + this.duration + ")";
        }
    }

    private static final class AudioFileResourceBuilderImpl
    extends AudioFileResourceBuilder<AudioFileResource, AudioFileResourceBuilderImpl> {
        private AudioFileResourceBuilderImpl() {
        }

        @Override
        protected AudioFileResourceBuilderImpl self() {
            return this;
        }

        @Override
        public AudioFileResource prebuild() {
            return new AudioFileResource(this);
        }
    }
}

