/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.identifiable.relation;

import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.identifiable.entity.Entity;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class IdentifiableToEntityRelation {
    private Entity object;
    private String predicate;
    private Identifiable subject;
    private List<String> additionalPredicates;

    public static Builder builder() {
        return new Builder();
    }

    public IdentifiableToEntityRelation() {
    }

    public IdentifiableToEntityRelation(Identifiable subject, String predicate, Entity object) {
        this.subject = subject;
        this.predicate = predicate;
        this.object = object;
    }

    public Entity getObject() {
        return this.object;
    }

    public String getPredicate() {
        return this.predicate;
    }

    public Identifiable getSubject() {
        return this.subject;
    }

    public void setObject(Entity objectEntity) {
        this.object = objectEntity;
    }

    public void setPredicate(String predicate) {
        this.predicate = predicate;
    }

    public void setSubject(Identifiable subjectEntity) {
        this.subject = subjectEntity;
    }

    public List<String> getAdditionalPredicates() {
        return this.additionalPredicates;
    }

    public void setAdditionalPredicates(List<String> additionalPredicates) {
        this.additionalPredicates = additionalPredicates;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdentifiableToEntityRelation)) {
            return false;
        }
        IdentifiableToEntityRelation that = (IdentifiableToEntityRelation)o;
        return Objects.equals(this.object, that.object) && Objects.equals(this.predicate, that.predicate) && Objects.equals(this.subject, that.subject) && Objects.equals(this.additionalPredicates, that.additionalPredicates);
    }

    public int hashCode() {
        return Objects.hash(this.object, this.predicate, this.subject, this.additionalPredicates);
    }

    public String toString() {
        return "IdentifiableToEntityRelation{object=" + this.object + ", predicate='" + this.predicate + "', subject=" + this.subject + ", additionalPredicates=" + this.additionalPredicates + "}";
    }

    public String toShortenedString() {
        return String.format("IdentifiableToEntityRelation{subject=%s, predicate='%s', object=%s}", this.subject != null ? this.subject.getUuid() : null, this.predicate, this.object != null ? this.object.getUuid() : null);
    }

    public static class Builder {
        IdentifiableToEntityRelation entityRelation = new IdentifiableToEntityRelation();

        public IdentifiableToEntityRelation build() {
            return this.entityRelation;
        }

        public Builder object(Entity objectEntity) {
            this.entityRelation.setObject(objectEntity);
            return this;
        }

        public Builder predicate(String predicate) {
            this.entityRelation.setPredicate(predicate);
            return this;
        }

        public Builder subject(Identifiable subjectEntity) {
            this.entityRelation.setSubject(subjectEntity);
            return this;
        }

        public Builder additionalPredicate(String additionalPredicate) {
            if (this.entityRelation.additionalPredicates == null) {
                this.entityRelation.additionalPredicates = new ArrayList<String>(1);
            }
            this.entityRelation.additionalPredicates.add(additionalPredicate);
            return this;
        }

        public Builder additionalPredicates(List<String> additionalPredicates) {
            this.entityRelation.setAdditionalPredicates(additionalPredicates);
            return this;
        }
    }
}

