/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.identifiable.entity.work;

import de.digitalcollections.model.identifiable.IdentifiableObjectType;
import de.digitalcollections.model.identifiable.entity.Entity;
import de.digitalcollections.model.identifiable.entity.relation.EntityRelation;
import de.digitalcollections.model.text.Title;
import de.digitalcollections.model.time.LocalDateRange;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.wikidata.wdtk.datamodel.interfaces.TimeValue;

public class Work
extends Entity {
    private LocalDateRange creationDateRange;
    private TimeValue creationTimeValue;
    private LocalDate firstAppearedDate;
    private String firstAppearedDatePresentation;
    private TimeValue firstAppearedTimeValue;
    private List<Work> parents;
    private List<EntityRelation> relations;
    private List<Title> titles;

    public Work() {
    }

    public LocalDateRange getCreationDateRange() {
        return this.creationDateRange;
    }

    public TimeValue getCreationTimeValue() {
        return this.creationTimeValue;
    }

    public LocalDate getFirstAppearedDate() {
        return this.firstAppearedDate;
    }

    public String getFirstAppearedDatePresentation() {
        return this.firstAppearedDatePresentation;
    }

    public TimeValue getFirstAppearedTimeValue() {
        return this.firstAppearedTimeValue;
    }

    public List<Work> getParents() {
        return this.parents;
    }

    public List<EntityRelation> getRelations() {
        return this.relations;
    }

    public List<Title> getTitles() {
        return this.titles;
    }

    @Override
    protected void init() {
        super.init();
        this.identifiableObjectType = IdentifiableObjectType.WORK;
        if (this.titles == null) {
            this.titles = new ArrayList<Title>(0);
        }
        if (this.relations == null) {
            this.relations = new ArrayList<EntityRelation>(0);
        }
        if (this.parents == null) {
            this.parents = new ArrayList<Work>(0);
        }
    }

    public void setCreationDateRange(LocalDateRange creationDateRange) {
        this.creationDateRange = creationDateRange;
    }

    public void setCreationTimeValue(TimeValue timeValueCreation) {
        this.creationTimeValue = timeValueCreation;
    }

    public void setFirstAppearedDate(LocalDate firstAppearedDate) {
        this.firstAppearedDate = firstAppearedDate;
    }

    public void setFirstAppearedDatePresentation(String firstAppearedDatePresentation) {
        this.firstAppearedDatePresentation = firstAppearedDatePresentation;
    }

    public void setFirstAppearedTimeValue(TimeValue firstAppearedTimeValue) {
        this.firstAppearedTimeValue = firstAppearedTimeValue;
    }

    public void setParents(List<Work> parents) {
        this.parents = parents;
    }

    public void addRelation(EntityRelation relation) {
        if (this.relations == null) {
            this.relations = new ArrayList<EntityRelation>(1);
        }
        this.relations.add(relation);
    }

    public void setRelations(List<EntityRelation> relations) {
        this.relations = relations;
    }

    public void setTitle(String title) {
        this.setLabel(title);
    }

    public void setTitles(List<Title> titles) {
        this.titles = titles;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Work)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Work work = (Work)o;
        return Objects.equals(this.creationDateRange, work.creationDateRange) && Objects.equals(this.creationTimeValue, work.creationTimeValue) && Objects.equals(this.firstAppearedDate, work.firstAppearedDate) && Objects.equals(this.firstAppearedDatePresentation, work.firstAppearedDatePresentation) && Objects.equals(this.firstAppearedTimeValue, work.firstAppearedTimeValue) && Objects.equals(this.parents, work.parents) && Objects.equals(this.relations, work.relations) && Objects.equals(this.titles, work.titles);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.creationDateRange, this.creationTimeValue, this.firstAppearedDate, this.firstAppearedDatePresentation, this.firstAppearedTimeValue, this.parents, this.relations, this.titles);
    }

    public String toString() {
        return "Work{creationDateRange=" + this.creationDateRange + ", creationTimeValue=" + this.creationTimeValue + ", firstAppearedDate=" + this.firstAppearedDate + ", firstAppearedDatePresentation='" + this.firstAppearedDatePresentation + "', firstAppearedTimeValue=" + this.firstAppearedTimeValue + ", parents=" + this.parents + ", relations=" + (this.relations == null ? "null" : this.relations.stream().map(r -> "{" + (r.getSubject() != null ? r.getSubject().getUuid() : null) + " " + r.getPredicate() + " " + (r.getObject() != null ? r.getObject().getUuid() : null) + "}").collect(Collectors.joining(", "))) + ", subjects=" + this.subjects + ", titles=" + this.titles + ", customAttributes=" + this.customAttributes + ", navDate=" + this.navDate + ", refId=" + this.refId + ", notes=" + this.notes + ", description=" + this.description + ", identifiableObjectType=" + this.identifiableObjectType + ", identifiers=" + this.identifiers + ", label=" + this.label + ", localizedUrlAliases=" + this.localizedUrlAliases + ", previewImage=" + this.previewImage + ", previewImageRenderingHints=" + this.previewImageRenderingHints + ", tags=" + this.tags + ", type=" + this.type + ", created=" + this.created + ", lastModified=" + this.lastModified + ", uuid=" + this.uuid + "}";
    }

    protected Work(WorkBuilder<?, ?> b) {
        super((Entity.EntityBuilder<?, ?>)b);
        this.creationDateRange = b.creationDateRange;
        this.creationTimeValue = b.creationTimeValue;
        this.firstAppearedDate = b.firstAppearedDate;
        this.firstAppearedDatePresentation = b.firstAppearedDatePresentation;
        this.firstAppearedTimeValue = b.firstAppearedTimeValue;
        this.parents = b.parents;
        this.relations = b.relations;
        this.titles = b.titles;
    }

    public static WorkBuilder<?, ?> builder() {
        return new WorkBuilderImpl();
    }

    public static abstract class WorkBuilder<C extends Work, B extends WorkBuilder<C, B>>
    extends Entity.EntityBuilder<C, B> {
        private LocalDateRange creationDateRange;
        private TimeValue creationTimeValue;
        private LocalDate firstAppearedDate;
        private String firstAppearedDatePresentation;
        private TimeValue firstAppearedTimeValue;
        private List<Work> parents;
        private List<EntityRelation> relations;
        private List<Title> titles;

        @Override
        public C build() {
            Entity c = this.prebuild();
            ((Work)c).init();
            this.setInternalReferences(c);
            return (C)c;
        }

        public B relation(EntityRelation relation) {
            if (this.relations == null) {
                this.relations = new ArrayList<EntityRelation>(1);
            }
            this.relations.add(relation);
            return (B)this.self();
        }

        public B title(Title title) {
            if (this.titles == null) {
                this.titles = new ArrayList<Title>(1);
            }
            this.titles.add(title);
            return (B)this.self();
        }

        public B creationDateRange(LocalDateRange creationDateRange) {
            this.creationDateRange = creationDateRange;
            return (B)this.self();
        }

        public B creationTimeValue(TimeValue creationTimeValue) {
            this.creationTimeValue = creationTimeValue;
            return (B)this.self();
        }

        public B firstAppearedDate(LocalDate firstAppearedDate) {
            this.firstAppearedDate = firstAppearedDate;
            return (B)this.self();
        }

        public B firstAppearedDatePresentation(String firstAppearedDatePresentation) {
            this.firstAppearedDatePresentation = firstAppearedDatePresentation;
            return (B)this.self();
        }

        public B firstAppearedTimeValue(TimeValue firstAppearedTimeValue) {
            this.firstAppearedTimeValue = firstAppearedTimeValue;
            return (B)this.self();
        }

        public B parents(List<Work> parents) {
            this.parents = parents;
            return (B)this.self();
        }

        public B relations(List<EntityRelation> relations) {
            this.relations = relations;
            return (B)this.self();
        }

        public B titles(List<Title> titles) {
            this.titles = titles;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C prebuild();

        @Override
        public String toString() {
            return "Work.WorkBuilder(super=" + super.toString() + ", creationDateRange=" + this.creationDateRange + ", creationTimeValue=" + this.creationTimeValue + ", firstAppearedDate=" + this.firstAppearedDate + ", firstAppearedDatePresentation=" + this.firstAppearedDatePresentation + ", firstAppearedTimeValue=" + this.firstAppearedTimeValue + ", parents=" + this.parents + ", relations=" + this.relations + ", titles=" + this.titles + ")";
        }
    }

    private static final class WorkBuilderImpl
    extends WorkBuilder<Work, WorkBuilderImpl> {
        private WorkBuilderImpl() {
        }

        @Override
        protected WorkBuilderImpl self() {
            return this;
        }

        @Override
        public Work prebuild() {
            return new Work(this);
        }
    }
}

