/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.identifiable.entity.relation;

import de.digitalcollections.model.identifiable.entity.Entity;
import de.digitalcollections.model.identifiable.resource.FileResource;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class EntityToFileResourceRelation {
    private FileResource object;
    private String predicate;
    private Entity subject;
    private List<String> additionalPredicates;

    public static Builder builder() {
        return new Builder();
    }

    public EntityToFileResourceRelation() {
    }

    public EntityToFileResourceRelation(Entity subject, String predicate, FileResource object) {
        this.subject = subject;
        this.predicate = predicate;
        this.object = object;
    }

    public FileResource getObject() {
        return this.object;
    }

    public String getPredicate() {
        return this.predicate;
    }

    public Entity getSubject() {
        return this.subject;
    }

    public void setObject(FileResource objectFileResource) {
        this.object = objectFileResource;
    }

    public void setPredicate(String predicate) {
        this.predicate = predicate;
    }

    public void setSubject(Entity subjectEntity) {
        this.subject = subjectEntity;
    }

    public List<String> getAdditionalPredicates() {
        return this.additionalPredicates;
    }

    public void setAdditionalPredicates(List<String> additionalPredicates) {
        this.additionalPredicates = additionalPredicates;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EntityToFileResourceRelation)) {
            return false;
        }
        EntityToFileResourceRelation that = (EntityToFileResourceRelation)o;
        return Objects.equals(this.object, that.object) && Objects.equals(this.predicate, that.predicate) && Objects.equals(this.subject, that.subject) && Objects.equals(this.additionalPredicates, that.additionalPredicates);
    }

    public int hashCode() {
        return Objects.hash(this.object, this.predicate, this.subject, this.additionalPredicates);
    }

    public String toString() {
        return "EntityToFileResourceRelation{object=" + this.object + ", predicate='" + this.predicate + "', subject=" + this.subject + ", additionalPredicates=" + this.additionalPredicates + "}";
    }

    public String toShortenedString() {
        return String.format("EntityToFileResourceRelation{subject=%s, predicate='%s', object=%s}", this.subject != null ? this.subject.getUuid() : null, this.predicate, this.object != null ? this.object.getUuid() : null);
    }

    public static class Builder {
        EntityToFileResourceRelation relation = new EntityToFileResourceRelation();

        public EntityToFileResourceRelation build() {
            return this.relation;
        }

        public Builder object(FileResource objectFileResource) {
            this.relation.setObject(objectFileResource);
            return this;
        }

        public Builder predicate(String predicate) {
            this.relation.setPredicate(predicate);
            return this;
        }

        public Builder subject(Entity subjectEntity) {
            this.relation.setSubject(subjectEntity);
            return this;
        }

        public Builder additionalPredicate(String additionalPredicate) {
            if (this.relation.additionalPredicates == null) {
                this.relation.additionalPredicates = new ArrayList<String>(1);
            }
            this.relation.additionalPredicates.add(additionalPredicate);
            return this;
        }

        public Builder additionalPredicates(List<String> additionalPredicates) {
            this.relation.setAdditionalPredicates(additionalPredicates);
            return this;
        }
    }
}

