/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.identifiable.entity.relation;

import de.digitalcollections.model.identifiable.entity.Entity;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class EntityRelation {
    private Entity object;
    private String predicate;
    private Entity subject;
    private List<String> additionalPredicates;

    public static Builder builder() {
        return new Builder();
    }

    public EntityRelation() {
    }

    public EntityRelation(Entity subject, String predicate, Entity object) {
        this.subject = subject;
        this.predicate = predicate;
        this.object = object;
    }

    public Entity getObject() {
        return this.object;
    }

    public String getPredicate() {
        return this.predicate;
    }

    public Entity getSubject() {
        return this.subject;
    }

    public void setObject(Entity objectEntity) {
        this.object = objectEntity;
    }

    public void setPredicate(String predicate) {
        this.predicate = predicate;
    }

    public void setSubject(Entity subjectEntity) {
        this.subject = subjectEntity;
    }

    public List<String> getAdditionalPredicates() {
        return this.additionalPredicates;
    }

    public void setAdditionalPredicates(List<String> additionalPredicates) {
        this.additionalPredicates = additionalPredicates;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EntityRelation)) {
            return false;
        }
        EntityRelation that = (EntityRelation)o;
        return Objects.equals(this.object, that.object) && Objects.equals(this.predicate, that.predicate) && Objects.equals(this.subject, that.subject) && Objects.equals(this.additionalPredicates, that.additionalPredicates);
    }

    public int hashCode() {
        return Objects.hash(this.object, this.predicate, this.subject, this.additionalPredicates);
    }

    public String toString() {
        return "EntityRelation{object=" + this.object + ", predicate='" + this.predicate + "', subject=" + this.subject + ", additionalPredicates=" + this.additionalPredicates + "}";
    }

    public String toShortenedString() {
        return String.format("EntityRelation{subject=%s, predicate='%s', object=%s}", this.subject != null ? this.subject.getUuid() : null, this.predicate, this.object != null ? this.object.getUuid() : null);
    }

    public static class Builder {
        EntityRelation entityRelation = new EntityRelation();

        public EntityRelation build() {
            return this.entityRelation;
        }

        public Builder object(Entity objectEntity) {
            this.entityRelation.setObject(objectEntity);
            return this;
        }

        public Builder predicate(String predicate) {
            this.entityRelation.setPredicate(predicate);
            return this;
        }

        public Builder subject(Entity subjectEntity) {
            this.entityRelation.setSubject(subjectEntity);
            return this;
        }

        public Builder additionalPredicate(String additionalPredicate) {
            if (this.entityRelation.additionalPredicates == null) {
                this.entityRelation.additionalPredicates = new ArrayList<String>(1);
            }
            this.entityRelation.additionalPredicates.add(additionalPredicate);
            return this;
        }

        public Builder additionalPredicates(List<String> additionalPredicates) {
            this.entityRelation.setAdditionalPredicates(additionalPredicates);
            return this;
        }
    }
}

