/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.identifiable.entity.manifestation;

import de.digitalcollections.model.identifiable.entity.manifestation.Publisher;
import de.digitalcollections.model.time.LocalDateRange;
import de.digitalcollections.model.time.TimeValueRange;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public abstract class PublishingInfo {
    protected List<Publisher> publishers;
    protected String datePresentation;
    protected LocalDateRange navDateRange;
    protected TimeValueRange timeValueRange;

    public PublishingInfo() {
    }

    public boolean isEmpty() {
        return (this.publishers == null || this.publishers.isEmpty()) && this.datePresentation == null && this.navDateRange == null && this.timeValueRange == null;
    }

    public List<Publisher> getPublishers() {
        return this.publishers;
    }

    public void setPublishers(List<Publisher> publishers) {
        this.publishers = publishers;
    }

    public String getDatePresentation() {
        return this.datePresentation;
    }

    public void setDatePresentation(String datePresentation) {
        this.datePresentation = datePresentation;
    }

    public LocalDateRange getNavDateRange() {
        return this.navDateRange;
    }

    public void setNavDateRange(LocalDateRange navDateRange) {
        this.navDateRange = navDateRange;
    }

    public TimeValueRange getTimeValueRange() {
        return this.timeValueRange;
    }

    public void setTimeValueRange(TimeValueRange timeValueRange) {
        this.timeValueRange = timeValueRange;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{publishers=" + this.publishers + ", datePresentation='" + this.datePresentation + "', navDateRange=" + this.navDateRange + ", timeValueRange=" + this.timeValueRange + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PublishingInfo)) {
            return false;
        }
        PublishingInfo that = (PublishingInfo)o;
        return Objects.equals(this.publishers, that.publishers) && Objects.equals(this.datePresentation, that.datePresentation) && Objects.equals(this.navDateRange, that.navDateRange) && Objects.equals(this.timeValueRange, that.timeValueRange);
    }

    public int hashCode() {
        return Objects.hash(this.publishers, this.datePresentation, this.navDateRange, this.timeValueRange);
    }

    protected PublishingInfo(PublishingInfoBuilder<?, ?> b) {
        this.publishers = b.publishers;
        this.datePresentation = b.datePresentation;
        this.navDateRange = b.navDateRange;
        this.timeValueRange = b.timeValueRange;
    }

    public static abstract class PublishingInfoBuilder<C extends PublishingInfo, B extends PublishingInfoBuilder<C, B>> {
        private List<Publisher> publishers;
        private String datePresentation;
        private LocalDateRange navDateRange;
        private TimeValueRange timeValueRange;

        public B publisher(Publisher publisher) {
            if (this.publishers == null) {
                this.publishers = new ArrayList<Publisher>(1);
            }
            this.publishers.add(publisher);
            return this.self();
        }

        public C build() {
            C c = this.prebuild();
            return c;
        }

        public B publishers(List<Publisher> publishers) {
            this.publishers = publishers;
            return this.self();
        }

        public B datePresentation(String datePresentation) {
            this.datePresentation = datePresentation;
            return this.self();
        }

        public B navDateRange(LocalDateRange navDateRange) {
            this.navDateRange = navDateRange;
            return this.self();
        }

        public B timeValueRange(TimeValueRange timeValueRange) {
            this.timeValueRange = timeValueRange;
            return this.self();
        }

        protected abstract B self();

        public abstract C prebuild();

        public String toString() {
            return "PublishingInfo.PublishingInfoBuilder(publishers=" + this.publishers + ", datePresentation=" + this.datePresentation + ", navDateRange=" + this.navDateRange + ", timeValueRange=" + this.timeValueRange + ")";
        }
    }
}

