/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.identifiable.entity.manifestation;

import de.digitalcollections.model.identifiable.entity.agent.Agent;
import de.digitalcollections.model.identifiable.entity.geo.location.HumanSettlement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Publisher {
    private List<HumanSettlement> locations;
    private Agent agent;
    private String datePresentation;

    public Publisher() {
    }

    public Publisher(List<HumanSettlement> locations, Agent agent, String datePresentation) {
        this();
        this.locations = locations;
        this.agent = agent;
        this.datePresentation = datePresentation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Publisher)) {
            return false;
        }
        Publisher publisher = (Publisher)o;
        return Objects.equals(this.locations, publisher.locations) && Objects.equals(this.agent, publisher.agent) && Objects.equals(this.datePresentation, publisher.datePresentation);
    }

    public int hashCode() {
        return Objects.hash(this.locations, this.agent, this.datePresentation);
    }

    public List<HumanSettlement> getLocations() {
        return this.locations;
    }

    public Agent getAgent() {
        return this.agent;
    }

    public void setLocations(List<HumanSettlement> locations) {
        this.locations = locations;
    }

    public void addLocation(HumanSettlement location) {
        if (this.locations == null) {
            this.locations = new ArrayList<HumanSettlement>(1);
        }
        this.locations.add(location);
    }

    public void setAgent(Agent agent) {
        this.agent = agent;
    }

    public String getDatePresentation() {
        return this.datePresentation;
    }

    public void setDatePresentation(String datePresentation) {
        this.datePresentation = datePresentation;
    }

    public String toString() {
        return "Publisher{locations=" + this.locations + ", agent=" + this.agent + ", datePresentation='" + this.datePresentation + "''}";
    }

    protected Publisher(PublisherBuilder<?, ?> b) {
        this.locations = b.locations;
        this.agent = b.agent;
        this.datePresentation = b.datePresentation;
    }

    public static PublisherBuilder<?, ?> builder() {
        return new PublisherBuilderImpl();
    }

    public static abstract class PublisherBuilder<C extends Publisher, B extends PublisherBuilder<C, B>> {
        private List<HumanSettlement> locations;
        private Agent agent;
        private String datePresentation;

        public C build() {
            C c = this.prebuild();
            return c;
        }

        public B location(HumanSettlement location) {
            if (this.locations == null) {
                this.locations = new ArrayList<HumanSettlement>(1);
            }
            this.locations.add(location);
            return this.self();
        }

        public B locations(List<HumanSettlement> locations) {
            this.locations = locations;
            return this.self();
        }

        public B agent(Agent agent) {
            this.agent = agent;
            return this.self();
        }

        public B datePresentation(String datePresentation) {
            this.datePresentation = datePresentation;
            return this.self();
        }

        protected abstract B self();

        public abstract C prebuild();

        public String toString() {
            return "Publisher.PublisherBuilder(locations=" + this.locations + ", agent=" + this.agent + ", datePresentation=" + this.datePresentation + ")";
        }
    }

    private static final class PublisherBuilderImpl
    extends PublisherBuilder<Publisher, PublisherBuilderImpl> {
        private PublisherBuilderImpl() {
        }

        @Override
        protected PublisherBuilderImpl self() {
            return this;
        }

        @Override
        public Publisher prebuild() {
            return new Publisher(this);
        }
    }
}

