/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.identifiable.entity.manifestation;

import de.digitalcollections.model.RelationSpecification;
import de.digitalcollections.model.identifiable.IdentifiableObjectType;
import de.digitalcollections.model.identifiable.entity.Entity;
import de.digitalcollections.model.identifiable.entity.manifestation.DistributionInfo;
import de.digitalcollections.model.identifiable.entity.manifestation.ExpressionType;
import de.digitalcollections.model.identifiable.entity.manifestation.ProductionInfo;
import de.digitalcollections.model.identifiable.entity.manifestation.PublicationInfo;
import de.digitalcollections.model.identifiable.entity.relation.EntityRelation;
import de.digitalcollections.model.identifiable.entity.work.Work;
import de.digitalcollections.model.text.Title;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;

public class Manifestation
extends Entity {
    private String composition;
    private String dimensions;
    private LinkedHashSet<ExpressionType> expressionTypes;
    private List<EntityRelation> relations;
    private Locale language;
    private String manifestationType;
    private String manufacturingType;
    private LinkedHashSet<String> mediaTypes;
    private LinkedHashSet<Locale> otherLanguages;
    private List<RelationSpecification<Manifestation>> parents;
    private PublicationInfo publicationInfo;
    private DistributionInfo distributionInfo;
    private ProductionInfo productionInfo;
    private String scale;
    private List<Title> titles;
    private String version;
    private Work work;

    public Manifestation() {
    }

    public void addParent(RelationSpecification<Manifestation> parent) {
        if (this.parents == null) {
            this.parents = new ArrayList<RelationSpecification<Manifestation>>();
        }
        this.parents.add(parent);
    }

    public void addRelation(EntityRelation relation) {
        this.relations.add(relation);
    }

    public String getComposition() {
        return this.composition;
    }

    public String getDimensions() {
        return this.dimensions;
    }

    public LinkedHashSet<ExpressionType> getExpressionTypes() {
        return this.expressionTypes;
    }

    public List<EntityRelation> getRelations() {
        return this.relations;
    }

    public Locale getLanguage() {
        return this.language;
    }

    public String getManifestationType() {
        return this.manifestationType;
    }

    public String getManufacturingType() {
        return this.manufacturingType;
    }

    public LinkedHashSet<String> getMediaTypes() {
        return this.mediaTypes;
    }

    public LinkedHashSet<Locale> getOtherLanguages() {
        return this.otherLanguages;
    }

    public List<RelationSpecification<Manifestation>> getParents() {
        return this.parents;
    }

    public PublicationInfo getPublicationInfo() {
        return this.publicationInfo;
    }

    public DistributionInfo getDistributionInfo() {
        return this.distributionInfo;
    }

    public ProductionInfo getProductionInfo() {
        return this.productionInfo;
    }

    public String getScale() {
        return this.scale;
    }

    public List<Title> getTitles() {
        return this.titles;
    }

    public String getVersion() {
        return this.version;
    }

    public Work getWork() {
        return this.work;
    }

    @Override
    protected void init() {
        super.init();
        this.identifiableObjectType = IdentifiableObjectType.MANIFESTATION;
        if (this.expressionTypes == null) {
            this.expressionTypes = new LinkedHashSet(0);
        }
        if (this.mediaTypes == null) {
            this.mediaTypes = new LinkedHashSet(0);
        }
        if (this.otherLanguages == null) {
            this.otherLanguages = new LinkedHashSet(0);
        }
        if (this.parents == null) {
            this.parents = new ArrayList<RelationSpecification<Manifestation>>(0);
        }
        if (this.titles == null) {
            this.titles = new ArrayList<Title>();
        }
        if (this.relations == null) {
            this.relations = new ArrayList<EntityRelation>();
        }
    }

    public void setComposition(String composition) {
        this.composition = composition;
    }

    public void setDimensions(String dimensions) {
        this.dimensions = dimensions;
    }

    public void setExpressionTypes(LinkedHashSet<ExpressionType> expressionTypes) {
        this.expressionTypes = expressionTypes;
    }

    public void setRelations(List<EntityRelation> relations) {
        this.relations = relations;
    }

    public void setLanguage(Locale language) {
        this.language = language;
    }

    public void setManifestationType(String manifestationType) {
        this.manifestationType = manifestationType;
    }

    public void setManufacturingType(String manufacturingType) {
        this.manufacturingType = manufacturingType;
    }

    public void setMediaTypes(LinkedHashSet<String> mediaTypes) {
        this.mediaTypes = mediaTypes;
    }

    public void setOtherLanguages(LinkedHashSet<Locale> otherLanguages) {
        this.otherLanguages = otherLanguages;
    }

    public void setParents(List<RelationSpecification<Manifestation>> parents) {
        this.parents = parents;
    }

    public void setPublicationInfo(PublicationInfo publicationInfo) {
        this.publicationInfo = publicationInfo;
    }

    public void setDistributionInfo(DistributionInfo distributionInfo) {
        this.distributionInfo = distributionInfo;
    }

    public void setProductionInfo(ProductionInfo productionInfo) {
        this.productionInfo = productionInfo;
    }

    public void setScale(String scale) {
        this.scale = scale;
    }

    public void setTitles(List<Title> titles) {
        this.titles = titles;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setWork(Work work) {
        this.work = work;
    }

    public String toString() {
        return "Manifestation{composition='" + this.composition + "', dimensions='" + this.dimensions + "', expressionTypes=" + this.expressionTypes + ", relations=" + this.dumpShortenedRelations(this.relations) + ", language=" + this.language + ", manifestationType=" + this.manifestationType + ", manufacturingType=" + this.manufacturingType + ", mediaTypes=" + this.mediaTypes + ", otherLanguages=" + this.otherLanguages + ", parents=" + this.parents + ", publicationInfo=" + this.publicationInfo + ", distributionInfo=" + this.distributionInfo + ", productionInfo=" + this.productionInfo + ", scale='" + this.scale + "', subjects=" + this.subjects + ", titles=" + this.titles + ", version='" + this.version + "', work=" + this.work + ", customAttributes=" + this.customAttributes + ", navDate=" + this.navDate + ", refId=" + this.refId + ", notes=" + this.notes + ", description=" + this.description + ", identifiableObjectType=" + this.identifiableObjectType + ", identifiers=" + this.identifiers + ", label=" + this.label + ", localizedUrlAliases=" + this.localizedUrlAliases + ", previewImage=" + this.previewImage + ", previewImageRenderingHints=" + this.previewImageRenderingHints + ", tags=" + this.tags + ", type=" + this.type + ", created=" + this.created + ", lastModified=" + this.lastModified + ", uuid=" + this.uuid + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Manifestation)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Manifestation that = (Manifestation)o;
        return Objects.equals(this.composition, that.composition) && Objects.equals(this.dimensions, that.dimensions) && Objects.equals(this.expressionTypes, that.expressionTypes) && Objects.equals(this.relations, that.relations) && Objects.equals(this.language, that.language) && Objects.equals(this.manifestationType, that.manifestationType) && Objects.equals(this.manufacturingType, that.manufacturingType) && Objects.equals(this.mediaTypes, that.mediaTypes) && Objects.equals(this.otherLanguages, that.otherLanguages) && Objects.equals(this.parents, that.parents) && Objects.equals(this.publicationInfo, that.publicationInfo) && Objects.equals(this.distributionInfo, that.distributionInfo) && Objects.equals(this.productionInfo, that.productionInfo) && Objects.equals(this.scale, that.scale) && Objects.equals(this.titles, that.titles) && Objects.equals(this.version, that.version) && Objects.equals(this.work, that.work);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.composition, this.dimensions, this.expressionTypes, this.relations, this.language, this.manifestationType, this.manufacturingType, this.mediaTypes, this.otherLanguages, this.parents, this.publicationInfo, this.distributionInfo, this.productionInfo, this.scale, this.titles, this.version, this.work);
    }

    private String dumpShortenedRelations(List<EntityRelation> relations) {
        return "[" + relations.stream().map(EntityRelation::toShortenedString).collect(Collectors.joining(",")) + "]";
    }

    protected Manifestation(ManifestationBuilder<?, ?> b) {
        super((Entity.EntityBuilder<?, ?>)b);
        this.composition = b.composition;
        this.dimensions = b.dimensions;
        this.expressionTypes = b.expressionTypes;
        this.relations = b.relations;
        this.language = b.language;
        this.manifestationType = b.manifestationType;
        this.manufacturingType = b.manufacturingType;
        this.mediaTypes = b.mediaTypes;
        this.otherLanguages = b.otherLanguages;
        this.parents = b.parents;
        this.publicationInfo = b.publicationInfo;
        this.distributionInfo = b.distributionInfo;
        this.productionInfo = b.productionInfo;
        this.scale = b.scale;
        this.titles = b.titles;
        this.version = b.version;
        this.work = b.work;
    }

    public static ManifestationBuilder<?, ?> builder() {
        return new ManifestationBuilderImpl();
    }

    public static abstract class ManifestationBuilder<C extends Manifestation, B extends ManifestationBuilder<C, B>>
    extends Entity.EntityBuilder<C, B> {
        private String composition;
        private String dimensions;
        private LinkedHashSet<ExpressionType> expressionTypes;
        private List<EntityRelation> relations;
        private Locale language;
        private String manifestationType;
        private String manufacturingType;
        private LinkedHashSet<String> mediaTypes;
        private LinkedHashSet<Locale> otherLanguages;
        private List<RelationSpecification<Manifestation>> parents;
        private PublicationInfo publicationInfo;
        private DistributionInfo distributionInfo;
        private ProductionInfo productionInfo;
        private String scale;
        private List<Title> titles;
        private String version;
        private Work work;

        @Override
        public C build() {
            Entity c = this.prebuild();
            ((Manifestation)c).init();
            this.setInternalReferences(c);
            return (C)c;
        }

        public B expressionType(ExpressionType type) {
            if (this.expressionTypes == null) {
                this.expressionTypes = new LinkedHashSet(1);
            }
            this.expressionTypes.add(type);
            return (B)this.self();
        }

        public B relation(EntityRelation relation) {
            if (this.relations == null) {
                this.relations = new ArrayList<EntityRelation>(1);
            }
            this.relations.add(relation);
            return (B)this.self();
        }

        public B manifestationType(String manifestationType) {
            this.manifestationType = manifestationType;
            return (B)this.self();
        }

        public B mediaType(String mediaType) {
            if (this.mediaTypes == null) {
                this.mediaTypes = new LinkedHashSet(1);
            }
            this.mediaTypes.add(mediaType);
            return (B)this.self();
        }

        public B otherLanguage(Locale lang) {
            if (this.otherLanguages == null) {
                this.otherLanguages = new LinkedHashSet(1);
            }
            this.otherLanguages.add(lang);
            return (B)this.self();
        }

        public B parent(RelationSpecification<Manifestation> parent) {
            if (this.parents == null) {
                this.parents = new ArrayList<RelationSpecification<Manifestation>>(1);
            }
            this.parents.add(parent);
            return (B)this.self();
        }

        public B title(Title title) {
            if (this.titles == null) {
                this.titles = new ArrayList<Title>(1);
            }
            this.titles.add(title);
            return (B)this.self();
        }

        public B composition(String composition) {
            this.composition = composition;
            return (B)this.self();
        }

        public B dimensions(String dimensions) {
            this.dimensions = dimensions;
            return (B)this.self();
        }

        public B expressionTypes(LinkedHashSet<ExpressionType> expressionTypes) {
            this.expressionTypes = expressionTypes;
            return (B)this.self();
        }

        public B relations(List<EntityRelation> relations) {
            this.relations = relations;
            return (B)this.self();
        }

        public B language(Locale language) {
            this.language = language;
            return (B)this.self();
        }

        public B manufacturingType(String manufacturingType) {
            this.manufacturingType = manufacturingType;
            return (B)this.self();
        }

        public B mediaTypes(LinkedHashSet<String> mediaTypes) {
            this.mediaTypes = mediaTypes;
            return (B)this.self();
        }

        public B otherLanguages(LinkedHashSet<Locale> otherLanguages) {
            this.otherLanguages = otherLanguages;
            return (B)this.self();
        }

        public B parents(List<RelationSpecification<Manifestation>> parents) {
            this.parents = parents;
            return (B)this.self();
        }

        public B publicationInfo(PublicationInfo publicationInfo) {
            this.publicationInfo = publicationInfo;
            return (B)this.self();
        }

        public B distributionInfo(DistributionInfo distributionInfo) {
            this.distributionInfo = distributionInfo;
            return (B)this.self();
        }

        public B productionInfo(ProductionInfo productionInfo) {
            this.productionInfo = productionInfo;
            return (B)this.self();
        }

        public B scale(String scale) {
            this.scale = scale;
            return (B)this.self();
        }

        public B titles(List<Title> titles) {
            this.titles = titles;
            return (B)this.self();
        }

        public B version(String version) {
            this.version = version;
            return (B)this.self();
        }

        public B work(Work work) {
            this.work = work;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C prebuild();

        @Override
        public String toString() {
            return "Manifestation.ManifestationBuilder(super=" + super.toString() + ", composition=" + this.composition + ", dimensions=" + this.dimensions + ", expressionTypes=" + this.expressionTypes + ", relations=" + this.relations + ", language=" + this.language + ", manifestationType=" + this.manifestationType + ", manufacturingType=" + this.manufacturingType + ", mediaTypes=" + this.mediaTypes + ", otherLanguages=" + this.otherLanguages + ", parents=" + this.parents + ", publicationInfo=" + this.publicationInfo + ", distributionInfo=" + this.distributionInfo + ", productionInfo=" + this.productionInfo + ", scale=" + this.scale + ", titles=" + this.titles + ", version=" + this.version + ", work=" + this.work + ")";
        }
    }

    private static final class ManifestationBuilderImpl
    extends ManifestationBuilder<Manifestation, ManifestationBuilderImpl> {
        private ManifestationBuilderImpl() {
        }

        @Override
        protected ManifestationBuilderImpl self() {
            return this;
        }

        @Override
        public Manifestation prebuild() {
            return new Manifestation(this);
        }
    }
}

