/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.identifiable.entity.item;

import de.digitalcollections.model.identifiable.entity.Entity;
import de.digitalcollections.model.identifiable.entity.agent.Agent;
import de.digitalcollections.model.identifiable.entity.manifestation.Manifestation;
import de.digitalcollections.model.text.LocalizedText;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Item
extends Entity {
    private Boolean exemplifiesManifestation;
    private Manifestation manifestation;
    private List<Agent> holders;
    private Item partOfItem;

    public Item() {
    }

    public LocalizedText getTitle() {
        return this.getLabel();
    }

    @Override
    protected void init() {
        super.init();
        if (this.holders == null) {
            this.holders = new ArrayList<Agent>(0);
        }
    }

    public void setTitle(LocalizedText title) {
        this.setLabel(title);
    }

    public void setTitle(String title) {
        this.setLabel(title);
    }

    public Boolean getExemplifiesManifestation() {
        return this.exemplifiesManifestation;
    }

    public void setExemplifiesManifestation(Boolean exemplifiesManifestation) {
        this.exemplifiesManifestation = exemplifiesManifestation;
    }

    public Manifestation getManifestation() {
        return this.manifestation;
    }

    public void setManifestation(Manifestation manifestation) {
        this.manifestation = manifestation;
    }

    public List<Agent> getHolders() {
        return this.holders;
    }

    public void setHolders(List<Agent> holders) {
        this.holders = holders;
    }

    public Item getPartOfItem() {
        return this.partOfItem;
    }

    public void setPartOfItem(Item partOfItem) {
        this.partOfItem = partOfItem;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Item)) {
            return false;
        }
        Item item = (Item)o;
        return super.equals(o) && Objects.equals(this.exemplifiesManifestation, item.exemplifiesManifestation) && Objects.equals(this.manifestation, item.manifestation) && Objects.equals(this.holders, item.holders) && Objects.equals(this.partOfItem, item.partOfItem);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Objects.hash(this.exemplifiesManifestation, this.manifestation, this.holders, this.partOfItem);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{exemplifiesManifestation=" + this.exemplifiesManifestation + ", manifestation=" + this.manifestation + ", holders=" + this.holders + ", notes=" + this.notes + ", partOfItem=" + this.partOfItem + ", customAttributes=" + this.customAttributes + ", identifiableObjecttype=" + this.identifiableObjectType + ", navDate=" + this.navDate + ", refId=" + this.refId + ", description=" + this.description + ", identifiers=" + this.identifiers + ", label=" + this.label + ", localizedUrlAliases=" + this.localizedUrlAliases + ", previewImage=" + this.previewImage + ", previewImageRenderingHints=" + this.previewImageRenderingHints + ", type=" + this.type + ", created=" + this.created + ", lastModified=" + this.lastModified + ", uuid=" + this.uuid + "}";
    }

    protected Item(ItemBuilder<?, ?> b) {
        super((Entity.EntityBuilder<?, ?>)b);
        this.exemplifiesManifestation = b.exemplifiesManifestation;
        this.manifestation = b.manifestation;
        this.holders = b.holders;
        this.partOfItem = b.partOfItem;
    }

    public static ItemBuilder<?, ?> builder() {
        return new ItemBuilderImpl();
    }

    public static abstract class ItemBuilder<C extends Item, B extends ItemBuilder<C, B>>
    extends Entity.EntityBuilder<C, B> {
        private Boolean exemplifiesManifestation;
        private Manifestation manifestation;
        private List<Agent> holders;
        private Item partOfItem;

        @Override
        public C build() {
            Entity c = this.prebuild();
            ((Item)c).init();
            this.setInternalReferences(c);
            return (C)c;
        }

        public B exemplifiesManifestation(Boolean exemplifiesManifestation) {
            this.exemplifiesManifestation = exemplifiesManifestation;
            return (B)this.self();
        }

        public B manifestation(Manifestation manifestation) {
            this.manifestation = manifestation;
            return (B)this.self();
        }

        public B holders(List<Agent> holders) {
            this.holders = holders;
            return (B)this.self();
        }

        public B partOfItem(Item partOfItem) {
            this.partOfItem = partOfItem;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C prebuild();

        @Override
        public String toString() {
            return "Item.ItemBuilder(super=" + super.toString() + ", exemplifiesManifestation=" + this.exemplifiesManifestation + ", manifestation=" + this.manifestation + ", holders=" + this.holders + ", partOfItem=" + this.partOfItem + ")";
        }
    }

    private static final class ItemBuilderImpl
    extends ItemBuilder<Item, ItemBuilderImpl> {
        private ItemBuilderImpl() {
        }

        @Override
        protected ItemBuilderImpl self() {
            return this;
        }

        @Override
        public Item prebuild() {
            return new Item(this);
        }
    }
}

